package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ImageLabelBuilder extends io.fabric8.openshift.api.model.ImageLabelFluentImpl<io.fabric8.openshift.api.model.ImageLabelBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.ImageLabel,io.fabric8.openshift.api.model.ImageLabelBuilder>{
  public ImageLabelBuilder() {
    this(false);
  }
  public ImageLabelBuilder(java.lang.Boolean validationEnabled) {
    this(new ImageLabel(), validationEnabled);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageLabel(), validationEnabled);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent,io.fabric8.openshift.api.model.ImageLabel instance) {
    this(fluent, instance, false);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent,io.fabric8.openshift.api.model.ImageLabel instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabel instance) {
    this(instance,false);
  }
  public ImageLabelBuilder(io.fabric8.openshift.api.model.ImageLabel instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageLabelFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageLabel build() {
    ImageLabel buildable = new ImageLabel(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageLabelBuilder that = (ImageLabelBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}