package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceQuotaStatusByNamespaceBuilder extends ResourceQuotaStatusByNamespaceFluentImpl<ResourceQuotaStatusByNamespaceBuilder> implements VisitableBuilder<ResourceQuotaStatusByNamespace,ResourceQuotaStatusByNamespaceBuilder> {

    ResourceQuotaStatusByNamespaceFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceQuotaStatusByNamespaceBuilder() { 
        this(true);
    }


    public ResourceQuotaStatusByNamespaceBuilder(Boolean validationEnabled) { 
        this(new ResourceQuotaStatusByNamespace(), validationEnabled);
    }


    public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespaceFluent<?> fluent) { 
        this(fluent, true);
    }


    public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespaceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ResourceQuotaStatusByNamespace(), validationEnabled);
    }


    public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespaceFluent<?> fluent,ResourceQuotaStatusByNamespace instance) { 
        this(fluent, instance, true);
    }


    public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespaceFluent<?> fluent,ResourceQuotaStatusByNamespace instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespace instance) { 
        this(instance,true);
    }


    public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespace instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withNamespace(instance.getNamespace()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ResourceQuotaStatusByNamespace build() {
        ResourceQuotaStatusByNamespace buildable = new ResourceQuotaStatusByNamespace(fluent.getNamespace(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceQuotaStatusByNamespaceBuilder that = (ResourceQuotaStatusByNamespaceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
