package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RangeAllocationListFluent<A extends RangeAllocationListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,RangeAllocation item);
    public A setToItems(int index,RangeAllocation item);
    public A addToItems(RangeAllocation... items);
    public A addAllToItems(Collection<RangeAllocation> items);
    public A removeFromItems(RangeAllocation... items);
    public A removeAllFromItems(Collection<RangeAllocation> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<RangeAllocationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<RangeAllocation> getItems();
    public List<RangeAllocation> buildItems();
    public RangeAllocation buildItem(int index);
    public RangeAllocation buildFirstItem();
    public RangeAllocation buildLastItem();
    public RangeAllocation buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<RangeAllocationBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<RangeAllocationBuilder> predicate);
    public A withItems(List<RangeAllocation> items);
    public A withItems(RangeAllocation... items);
    public Boolean hasItems();
    public RangeAllocationListFluent.ItemsNested<A> addNewItem();
    public RangeAllocationListFluent.ItemsNested<A> addNewItemLike(RangeAllocation item);
    public RangeAllocationListFluent.ItemsNested<A> setNewItemLike(int index,RangeAllocation item);
    public RangeAllocationListFluent.ItemsNested<A> editItem(int index);
    public RangeAllocationListFluent.ItemsNested<A> editFirstItem();
    public RangeAllocationListFluent.ItemsNested<A> editLastItem();
    public RangeAllocationListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<RangeAllocationBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RangeAllocationFluent<RangeAllocationListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
