package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ProxySpecFluentImpl<A extends ProxySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProxySpecFluent<A> {

    private String httpProxy;
    private String httpsProxy;
    private String noProxy;
    private List<String> readinessEndpoints = new ArrayList<String>();
    private ConfigMapNameReferenceBuilder trustedCA;

    public ProxySpecFluentImpl() { 
    }


    public ProxySpecFluentImpl(ProxySpec instance) { 
        this.withHttpProxy(instance.getHttpProxy()); 
        this.withHttpsProxy(instance.getHttpsProxy()); 
        this.withNoProxy(instance.getNoProxy()); 
        this.withReadinessEndpoints(instance.getReadinessEndpoints()); 
        this.withTrustedCA(instance.getTrustedCA()); 
    }


    public String getHttpProxy() {
        return this.httpProxy;
    }

    public A withHttpProxy(String httpProxy) {
        this.httpProxy=httpProxy; return (A) this;
    }

    public Boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    public A withNewHttpProxy(String arg1) {
        return (A)withHttpProxy(new String(arg1));
    }

    public A withNewHttpProxy(StringBuilder arg1) {
        return (A)withHttpProxy(new String(arg1));
    }

    public A withNewHttpProxy(StringBuffer arg1) {
        return (A)withHttpProxy(new String(arg1));
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public A withHttpsProxy(String httpsProxy) {
        this.httpsProxy=httpsProxy; return (A) this;
    }

    public Boolean hasHttpsProxy() {
        return this.httpsProxy != null;
    }

    public A withNewHttpsProxy(String arg1) {
        return (A)withHttpsProxy(new String(arg1));
    }

    public A withNewHttpsProxy(StringBuilder arg1) {
        return (A)withHttpsProxy(new String(arg1));
    }

    public A withNewHttpsProxy(StringBuffer arg1) {
        return (A)withHttpsProxy(new String(arg1));
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public A withNoProxy(String noProxy) {
        this.noProxy=noProxy; return (A) this;
    }

    public Boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public A withNewNoProxy(String arg1) {
        return (A)withNoProxy(new String(arg1));
    }

    public A withNewNoProxy(StringBuilder arg1) {
        return (A)withNoProxy(new String(arg1));
    }

    public A withNewNoProxy(StringBuffer arg1) {
        return (A)withNoProxy(new String(arg1));
    }

    public A addToReadinessEndpoints(int index,String item) {
        if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
        this.readinessEndpoints.add(index, item);
        return (A)this;
    }

    public A setToReadinessEndpoints(int index,String item) {
        if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
        this.readinessEndpoints.set(index, item); return (A)this;
    }

    public A addToReadinessEndpoints(String... items) {
        if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
        for (String item : items) {this.readinessEndpoints.add(item);} return (A)this;
    }

    public A addAllToReadinessEndpoints(Collection<String> items) {
        if (this.readinessEndpoints == null) {this.readinessEndpoints = new ArrayList<String>();}
        for (String item : items) {this.readinessEndpoints.add(item);} return (A)this;
    }

    public A removeFromReadinessEndpoints(String... items) {
        for (String item : items) {if (this.readinessEndpoints!= null){ this.readinessEndpoints.remove(item);}} return (A)this;
    }

    public A removeAllFromReadinessEndpoints(Collection<String> items) {
        for (String item : items) {if (this.readinessEndpoints!= null){ this.readinessEndpoints.remove(item);}} return (A)this;
    }

    public List<String> getReadinessEndpoints() {
        return this.readinessEndpoints;
    }

    public String getReadinessEndpoint(int index) {
        return this.readinessEndpoints.get(index);
    }

    public String getFirstReadinessEndpoint() {
        return this.readinessEndpoints.get(0);
    }

    public String getLastReadinessEndpoint() {
        return this.readinessEndpoints.get(readinessEndpoints.size() - 1);
    }

    public String getMatchingReadinessEndpoint(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: readinessEndpoints) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingReadinessEndpoint(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: readinessEndpoints) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withReadinessEndpoints(List<String> readinessEndpoints) {
        if (this.readinessEndpoints != null) { _visitables.get("readinessEndpoints").removeAll(this.readinessEndpoints);}
        if (readinessEndpoints != null) {this.readinessEndpoints = new ArrayList<String>(); for (String item : readinessEndpoints){this.addToReadinessEndpoints(item);}} else { this.readinessEndpoints = null;} return (A) this;
    }

    public A withReadinessEndpoints(String... readinessEndpoints) {
        if (this.readinessEndpoints != null) {this.readinessEndpoints.clear();}
        if (readinessEndpoints != null) {for (String item :readinessEndpoints){ this.addToReadinessEndpoints(item);}} return (A) this;
    }

    public Boolean hasReadinessEndpoints() {
        return readinessEndpoints != null && !readinessEndpoints.isEmpty();
    }

    public A addNewReadinessEndpoint(String arg1) {
        return (A)addToReadinessEndpoints(new String(arg1));
    }

    public A addNewReadinessEndpoint(StringBuilder arg1) {
        return (A)addToReadinessEndpoints(new String(arg1));
    }

    public A addNewReadinessEndpoint(StringBuffer arg1) {
        return (A)addToReadinessEndpoints(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTrustedCA instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapNameReference getTrustedCA() {
        return this.trustedCA!=null?this.trustedCA.build():null;
    }

    public ConfigMapNameReference buildTrustedCA() {
        return this.trustedCA!=null?this.trustedCA.build():null;
    }

    public A withTrustedCA(ConfigMapNameReference trustedCA) {
        _visitables.get("trustedCA").remove(this.trustedCA);
        if (trustedCA!=null){ this.trustedCA= new ConfigMapNameReferenceBuilder(trustedCA); _visitables.get("trustedCA").add(this.trustedCA);} return (A) this;
    }

    public Boolean hasTrustedCA() {
        return this.trustedCA != null;
    }

    public A withNewTrustedCA(String name) {
        return (A)withTrustedCA(new ConfigMapNameReference(name));
    }

    public ProxySpecFluent.TrustedCANested<A> withNewTrustedCA() {
        return new TrustedCANestedImpl();
    }

    public ProxySpecFluent.TrustedCANested<A> withNewTrustedCALike(ConfigMapNameReference item) {
        return new TrustedCANestedImpl(item);
    }

    public ProxySpecFluent.TrustedCANested<A> editTrustedCA() {
        return withNewTrustedCALike(getTrustedCA());
    }

    public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCA() {
        return withNewTrustedCALike(getTrustedCA() != null ? getTrustedCA(): new ConfigMapNameReferenceBuilder().build());
    }

    public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCALike(ConfigMapNameReference item) {
        return withNewTrustedCALike(getTrustedCA() != null ? getTrustedCA(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProxySpecFluentImpl that = (ProxySpecFluentImpl) o;
        if (httpProxy != null ? !httpProxy.equals(that.httpProxy) :that.httpProxy != null) return false;
        if (httpsProxy != null ? !httpsProxy.equals(that.httpsProxy) :that.httpsProxy != null) return false;
        if (noProxy != null ? !noProxy.equals(that.noProxy) :that.noProxy != null) return false;
        if (readinessEndpoints != null ? !readinessEndpoints.equals(that.readinessEndpoints) :that.readinessEndpoints != null) return false;
        if (trustedCA != null ? !trustedCA.equals(that.trustedCA) :that.trustedCA != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(httpProxy,  httpsProxy,  noProxy,  readinessEndpoints,  trustedCA,  super.hashCode());
    }

    public class TrustedCANestedImpl<N> extends ConfigMapNameReferenceFluentImpl<ProxySpecFluent.TrustedCANested<N>> implements ProxySpecFluent.TrustedCANested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapNameReferenceBuilder builder;

        TrustedCANestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        TrustedCANestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        public N and() {
             return (N) ProxySpecFluentImpl.this.withTrustedCA(builder.build());
        }

        public N endTrustedCA() {
             return and();
        }
    }


}
