package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicyReviewSpecBuilder extends PodSecurityPolicyReviewSpecFluentImpl<PodSecurityPolicyReviewSpecBuilder> implements VisitableBuilder<PodSecurityPolicyReviewSpec,PodSecurityPolicyReviewSpecBuilder> {

    PodSecurityPolicyReviewSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityPolicyReviewSpecBuilder() { 
        this(true);
    }


    public PodSecurityPolicyReviewSpecBuilder(Boolean validationEnabled) { 
        this(new PodSecurityPolicyReviewSpec(), validationEnabled);
    }


    public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PodSecurityPolicyReviewSpec(), validationEnabled);
    }


    public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpecFluent<?> fluent,PodSecurityPolicyReviewSpec instance) { 
        this(fluent, instance, true);
    }


    public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpecFluent<?> fluent,PodSecurityPolicyReviewSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withServiceAccountNames(instance.getServiceAccountNames()); 
        fluent.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpec instance) { 
        this(instance,true);
    }


    public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withServiceAccountNames(instance.getServiceAccountNames()); 
        this.withTemplate(instance.getTemplate()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodSecurityPolicyReviewSpec build() {
        PodSecurityPolicyReviewSpec buildable = new PodSecurityPolicyReviewSpec(fluent.getServiceAccountNames(),fluent.getTemplate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodSecurityPolicyReviewSpecBuilder that = (PodSecurityPolicyReviewSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
