package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterResourceQuotaListFluent<A extends ClusterResourceQuotaListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ClusterResourceQuota item);
    public A setToItems(int index,ClusterResourceQuota item);
    public A addToItems(ClusterResourceQuota... items);
    public A addAllToItems(Collection<ClusterResourceQuota> items);
    public A removeFromItems(ClusterResourceQuota... items);
    public A removeAllFromItems(Collection<ClusterResourceQuota> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ClusterResourceQuotaBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterResourceQuota> getItems();
    public List<ClusterResourceQuota> buildItems();
    public ClusterResourceQuota buildItem(int index);
    public ClusterResourceQuota buildFirstItem();
    public ClusterResourceQuota buildLastItem();
    public ClusterResourceQuota buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterResourceQuotaBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterResourceQuotaBuilder> predicate);
    public A withItems(List<ClusterResourceQuota> items);
    public A withItems(ClusterResourceQuota... items);
    public Boolean hasItems();
    public ClusterResourceQuotaListFluent.ItemsNested<A> addNewItem();
    public ClusterResourceQuotaListFluent.ItemsNested<A> addNewItemLike(ClusterResourceQuota item);
    public ClusterResourceQuotaListFluent.ItemsNested<A> setNewItemLike(int index,ClusterResourceQuota item);
    public ClusterResourceQuotaListFluent.ItemsNested<A> editItem(int index);
    public ClusterResourceQuotaListFluent.ItemsNested<A> editFirstItem();
    public ClusterResourceQuotaListFluent.ItemsNested<A> editLastItem();
    public ClusterResourceQuotaListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterResourceQuotaBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaFluent<ClusterResourceQuotaListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
