package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterNetworkBuilder extends ClusterNetworkFluentImpl<ClusterNetworkBuilder> implements VisitableBuilder<ClusterNetwork,ClusterNetworkBuilder> {

    ClusterNetworkFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterNetworkBuilder() { 
        this(true);
    }


    public ClusterNetworkBuilder(Boolean validationEnabled) { 
        this(new ClusterNetwork(), validationEnabled);
    }


    public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent) { 
        this(fluent, true);
    }


    public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ClusterNetwork(), validationEnabled);
    }


    public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent,ClusterNetwork instance) { 
        this(fluent, instance, true);
    }


    public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent,ClusterNetwork instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withClusterNetworks(instance.getClusterNetworks()); 
        fluent.withHostsubnetlength(instance.getHostsubnetlength()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withMtu(instance.getMtu()); 
        fluent.withNetwork(instance.getNetwork()); 
        fluent.withPluginName(instance.getPluginName()); 
        fluent.withServiceNetwork(instance.getServiceNetwork()); 
        fluent.withVxlanPort(instance.getVxlanPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterNetworkBuilder(ClusterNetwork instance) { 
        this(instance,true);
    }


    public ClusterNetworkBuilder(ClusterNetwork instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withClusterNetworks(instance.getClusterNetworks()); 
        this.withHostsubnetlength(instance.getHostsubnetlength()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withMtu(instance.getMtu()); 
        this.withNetwork(instance.getNetwork()); 
        this.withPluginName(instance.getPluginName()); 
        this.withServiceNetwork(instance.getServiceNetwork()); 
        this.withVxlanPort(instance.getVxlanPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterNetwork build() {
        ClusterNetwork buildable = new ClusterNetwork(fluent.getApiVersion(),fluent.getClusterNetworks(),fluent.getHostsubnetlength(),fluent.getKind(),fluent.getMetadata(),fluent.getMtu(),fluent.getNetwork(),fluent.getPluginName(),fluent.getServiceNetwork(),fluent.getVxlanPort());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterNetworkBuilder that = (ClusterNetworkBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
