package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerEncryptionBuilder extends APIServerEncryptionFluentImpl<APIServerEncryptionBuilder> implements VisitableBuilder<APIServerEncryption,APIServerEncryptionBuilder> {

    APIServerEncryptionFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerEncryptionBuilder() { 
        this(true);
    }


    public APIServerEncryptionBuilder(Boolean validationEnabled) { 
        this(new APIServerEncryption(), validationEnabled);
    }


    public APIServerEncryptionBuilder(APIServerEncryptionFluent<?> fluent) { 
        this(fluent, true);
    }


    public APIServerEncryptionBuilder(APIServerEncryptionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new APIServerEncryption(), validationEnabled);
    }


    public APIServerEncryptionBuilder(APIServerEncryptionFluent<?> fluent,APIServerEncryption instance) { 
        this(fluent, instance, true);
    }


    public APIServerEncryptionBuilder(APIServerEncryptionFluent<?> fluent,APIServerEncryption instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIServerEncryptionBuilder(APIServerEncryption instance) { 
        this(instance,true);
    }


    public APIServerEncryptionBuilder(APIServerEncryption instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIServerEncryption build() {
        APIServerEncryption buildable = new APIServerEncryption(fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServerEncryptionBuilder that = (APIServerEncryptionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
