package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class TLSSecurityProfileFluentImpl<A extends TLSSecurityProfileFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TLSSecurityProfileFluent<A> {

    private CustomTLSProfileBuilder custom;
    private IntermediateTLSProfileBuilder intermediate;
    private ModernTLSProfileBuilder modern;
    private OldTLSProfileBuilder old;
    private String type;

    public TLSSecurityProfileFluentImpl() { 
    }


    public TLSSecurityProfileFluentImpl(TLSSecurityProfile instance) { 
        this.withCustom(instance.getCustom()); 
        this.withIntermediate(instance.getIntermediate()); 
        this.withModern(instance.getModern()); 
        this.withOld(instance.getOld()); 
        this.withType(instance.getType()); 
    }


    
/**
 * This method has been deprecated, please use method buildCustom instead.
 * @return The buildable object.
 */
@Deprecated public CustomTLSProfile getCustom() {
        return this.custom!=null?this.custom.build():null;
    }

    public CustomTLSProfile buildCustom() {
        return this.custom!=null?this.custom.build():null;
    }

    public A withCustom(CustomTLSProfile custom) {
        _visitables.get("custom").remove(this.custom);
        if (custom!=null){ this.custom= new CustomTLSProfileBuilder(custom); _visitables.get("custom").add(this.custom);} return (A) this;
    }

    public Boolean hasCustom() {
        return this.custom != null;
    }

    public TLSSecurityProfileFluent.CustomNested<A> withNewCustom() {
        return new CustomNestedImpl();
    }

    public TLSSecurityProfileFluent.CustomNested<A> withNewCustomLike(CustomTLSProfile item) {
        return new CustomNestedImpl(item);
    }

    public TLSSecurityProfileFluent.CustomNested<A> editCustom() {
        return withNewCustomLike(getCustom());
    }

    public TLSSecurityProfileFluent.CustomNested<A> editOrNewCustom() {
        return withNewCustomLike(getCustom() != null ? getCustom(): new CustomTLSProfileBuilder().build());
    }

    public TLSSecurityProfileFluent.CustomNested<A> editOrNewCustomLike(CustomTLSProfile item) {
        return withNewCustomLike(getCustom() != null ? getCustom(): item);
    }

    
/**
 * This method has been deprecated, please use method buildIntermediate instead.
 * @return The buildable object.
 */
@Deprecated public IntermediateTLSProfile getIntermediate() {
        return this.intermediate!=null?this.intermediate.build():null;
    }

    public IntermediateTLSProfile buildIntermediate() {
        return this.intermediate!=null?this.intermediate.build():null;
    }

    public A withIntermediate(IntermediateTLSProfile intermediate) {
        _visitables.get("intermediate").remove(this.intermediate);
        if (intermediate!=null){ this.intermediate= new IntermediateTLSProfileBuilder(intermediate); _visitables.get("intermediate").add(this.intermediate);} return (A) this;
    }

    public Boolean hasIntermediate() {
        return this.intermediate != null;
    }

    public TLSSecurityProfileFluent.IntermediateNested<A> withNewIntermediate() {
        return new IntermediateNestedImpl();
    }

    public TLSSecurityProfileFluent.IntermediateNested<A> withNewIntermediateLike(IntermediateTLSProfile item) {
        return new IntermediateNestedImpl(item);
    }

    public TLSSecurityProfileFluent.IntermediateNested<A> editIntermediate() {
        return withNewIntermediateLike(getIntermediate());
    }

    public TLSSecurityProfileFluent.IntermediateNested<A> editOrNewIntermediate() {
        return withNewIntermediateLike(getIntermediate() != null ? getIntermediate(): new IntermediateTLSProfileBuilder().build());
    }

    public TLSSecurityProfileFluent.IntermediateNested<A> editOrNewIntermediateLike(IntermediateTLSProfile item) {
        return withNewIntermediateLike(getIntermediate() != null ? getIntermediate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildModern instead.
 * @return The buildable object.
 */
@Deprecated public ModernTLSProfile getModern() {
        return this.modern!=null?this.modern.build():null;
    }

    public ModernTLSProfile buildModern() {
        return this.modern!=null?this.modern.build():null;
    }

    public A withModern(ModernTLSProfile modern) {
        _visitables.get("modern").remove(this.modern);
        if (modern!=null){ this.modern= new ModernTLSProfileBuilder(modern); _visitables.get("modern").add(this.modern);} return (A) this;
    }

    public Boolean hasModern() {
        return this.modern != null;
    }

    public TLSSecurityProfileFluent.ModernNested<A> withNewModern() {
        return new ModernNestedImpl();
    }

    public TLSSecurityProfileFluent.ModernNested<A> withNewModernLike(ModernTLSProfile item) {
        return new ModernNestedImpl(item);
    }

    public TLSSecurityProfileFluent.ModernNested<A> editModern() {
        return withNewModernLike(getModern());
    }

    public TLSSecurityProfileFluent.ModernNested<A> editOrNewModern() {
        return withNewModernLike(getModern() != null ? getModern(): new ModernTLSProfileBuilder().build());
    }

    public TLSSecurityProfileFluent.ModernNested<A> editOrNewModernLike(ModernTLSProfile item) {
        return withNewModernLike(getModern() != null ? getModern(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOld instead.
 * @return The buildable object.
 */
@Deprecated public OldTLSProfile getOld() {
        return this.old!=null?this.old.build():null;
    }

    public OldTLSProfile buildOld() {
        return this.old!=null?this.old.build():null;
    }

    public A withOld(OldTLSProfile old) {
        _visitables.get("old").remove(this.old);
        if (old!=null){ this.old= new OldTLSProfileBuilder(old); _visitables.get("old").add(this.old);} return (A) this;
    }

    public Boolean hasOld() {
        return this.old != null;
    }

    public TLSSecurityProfileFluent.OldNested<A> withNewOld() {
        return new OldNestedImpl();
    }

    public TLSSecurityProfileFluent.OldNested<A> withNewOldLike(OldTLSProfile item) {
        return new OldNestedImpl(item);
    }

    public TLSSecurityProfileFluent.OldNested<A> editOld() {
        return withNewOldLike(getOld());
    }

    public TLSSecurityProfileFluent.OldNested<A> editOrNewOld() {
        return withNewOldLike(getOld() != null ? getOld(): new OldTLSProfileBuilder().build());
    }

    public TLSSecurityProfileFluent.OldNested<A> editOrNewOldLike(OldTLSProfile item) {
        return withNewOldLike(getOld() != null ? getOld(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TLSSecurityProfileFluentImpl that = (TLSSecurityProfileFluentImpl) o;
        if (custom != null ? !custom.equals(that.custom) :that.custom != null) return false;
        if (intermediate != null ? !intermediate.equals(that.intermediate) :that.intermediate != null) return false;
        if (modern != null ? !modern.equals(that.modern) :that.modern != null) return false;
        if (old != null ? !old.equals(that.old) :that.old != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(custom,  intermediate,  modern,  old,  type,  super.hashCode());
    }

    public class CustomNestedImpl<N> extends CustomTLSProfileFluentImpl<TLSSecurityProfileFluent.CustomNested<N>> implements TLSSecurityProfileFluent.CustomNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CustomTLSProfileBuilder builder;

        CustomNestedImpl(CustomTLSProfile item) {
            this.builder = new CustomTLSProfileBuilder(this, item);
        }

        CustomNestedImpl() {
            this.builder = new CustomTLSProfileBuilder(this);
        }

        public N and() {
             return (N) TLSSecurityProfileFluentImpl.this.withCustom(builder.build());
        }

        public N endCustom() {
             return and();
        }
    }


    public class IntermediateNestedImpl<N> extends IntermediateTLSProfileFluentImpl<TLSSecurityProfileFluent.IntermediateNested<N>> implements TLSSecurityProfileFluent.IntermediateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntermediateTLSProfileBuilder builder;

        IntermediateNestedImpl(IntermediateTLSProfile item) {
            this.builder = new IntermediateTLSProfileBuilder(this, item);
        }

        IntermediateNestedImpl() {
            this.builder = new IntermediateTLSProfileBuilder(this);
        }

        public N and() {
             return (N) TLSSecurityProfileFluentImpl.this.withIntermediate(builder.build());
        }

        public N endIntermediate() {
             return and();
        }
    }


    public class ModernNestedImpl<N> extends ModernTLSProfileFluentImpl<TLSSecurityProfileFluent.ModernNested<N>> implements TLSSecurityProfileFluent.ModernNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ModernTLSProfileBuilder builder;

        ModernNestedImpl(ModernTLSProfile item) {
            this.builder = new ModernTLSProfileBuilder(this, item);
        }

        ModernNestedImpl() {
            this.builder = new ModernTLSProfileBuilder(this);
        }

        public N and() {
             return (N) TLSSecurityProfileFluentImpl.this.withModern(builder.build());
        }

        public N endModern() {
             return and();
        }
    }


    public class OldNestedImpl<N> extends OldTLSProfileFluentImpl<TLSSecurityProfileFluent.OldNested<N>> implements TLSSecurityProfileFluent.OldNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OldTLSProfileBuilder builder;

        OldNestedImpl(OldTLSProfile item) {
            this.builder = new OldTLSProfileBuilder(this, item);
        }

        OldNestedImpl() {
            this.builder = new OldTLSProfileBuilder(this);
        }

        public N and() {
             return (N) TLSSecurityProfileFluentImpl.this.withOld(builder.build());
        }

        public N endOld() {
             return and();
        }
    }


}
