package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface RoleBindingFluent<A extends RoleBindingFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToGroupNames(int index,String item);
    public A setToGroupNames(int index,String item);
    public A addToGroupNames(String... items);
    public A addAllToGroupNames(Collection<String> items);
    public A removeFromGroupNames(String... items);
    public A removeAllFromGroupNames(Collection<String> items);
    public List<String> getGroupNames();
    public String getGroupName(int index);
    public String getFirstGroupName();
    public String getLastGroupName();
    public String getMatchingGroupName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingGroupName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withGroupNames(List<String> groupNames);
    public A withGroupNames(String... groupNames);
    public Boolean hasGroupNames();
    public A addNewGroupName(String arg1);
    public A addNewGroupName(StringBuilder arg1);
    public A addNewGroupName(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public RoleBindingFluent.MetadataNested<A> withNewMetadata();
    public RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RoleBindingFluent.MetadataNested<A> editMetadata();
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadata();
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildRoleRef instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getRoleRef();
    public io.fabric8.kubernetes.api.model.ObjectReference buildRoleRef();
    public A withRoleRef(io.fabric8.kubernetes.api.model.ObjectReference roleRef);
    public Boolean hasRoleRef();
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRef();
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public RoleBindingFluent.RoleRefNested<A> editRoleRef();
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef();
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public A addToSubjects(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public A setToSubjects(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public A addToSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items);
    public A addAllToSubjects(Collection<io.fabric8.kubernetes.api.model.ObjectReference> items);
    public A removeFromSubjects(io.fabric8.kubernetes.api.model.ObjectReference... items);
    public A removeAllFromSubjects(Collection<io.fabric8.kubernetes.api.model.ObjectReference> items);
    public A removeMatchingFromSubjects(io.fabric8.kubernetes.api.builder.Predicate<ObjectReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSubjects instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.ObjectReference> getSubjects();
    public List<io.fabric8.kubernetes.api.model.ObjectReference> buildSubjects();
    public io.fabric8.kubernetes.api.model.ObjectReference buildSubject(int index);
    public io.fabric8.kubernetes.api.model.ObjectReference buildFirstSubject();
    public io.fabric8.kubernetes.api.model.ObjectReference buildLastSubject();
    public io.fabric8.kubernetes.api.model.ObjectReference buildMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<ObjectReferenceBuilder> predicate);
    public Boolean hasMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<ObjectReferenceBuilder> predicate);
    public A withSubjects(List<io.fabric8.kubernetes.api.model.ObjectReference> subjects);
    public A withSubjects(io.fabric8.kubernetes.api.model.ObjectReference... subjects);
    public Boolean hasSubjects();
    public RoleBindingFluent.SubjectsNested<A> addNewSubject();
    public RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index,io.fabric8.kubernetes.api.model.ObjectReference item);
    public RoleBindingFluent.SubjectsNested<A> editSubject(int index);
    public RoleBindingFluent.SubjectsNested<A> editFirstSubject();
    public RoleBindingFluent.SubjectsNested<A> editLastSubject();
    public RoleBindingFluent.SubjectsNested<A> editMatchingSubject(io.fabric8.kubernetes.api.builder.Predicate<ObjectReferenceBuilder> predicate);
    public A addToUserNames(int index,String item);
    public A setToUserNames(int index,String item);
    public A addToUserNames(String... items);
    public A addAllToUserNames(Collection<String> items);
    public A removeFromUserNames(String... items);
    public A removeAllFromUserNames(Collection<String> items);
    public List<String> getUserNames();
    public String getUserName(int index);
    public String getFirstUserName();
    public String getLastUserName();
    public String getMatchingUserName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingUserName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withUserNames(List<String> userNames);
    public A withUserNames(String... userNames);
    public Boolean hasUserNames();
    public A addNewUserName(String arg1);
    public A addNewUserName(StringBuilder arg1);
    public A addNewUserName(StringBuffer arg1);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<RoleBindingFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface RoleRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<RoleBindingFluent.RoleRefNested<N>> {

        public N and();
        public N endRoleRef();    }


    public interface SubjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<RoleBindingFluent.SubjectsNested<N>> {

        public N and();
        public N endSubject();    }


}
