package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabIdentityProviderBuilder extends GitLabIdentityProviderFluentImpl<GitLabIdentityProviderBuilder> implements VisitableBuilder<GitLabIdentityProvider,GitLabIdentityProviderBuilder> {

    GitLabIdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public GitLabIdentityProviderBuilder() { 
        this(true);
    }


    public GitLabIdentityProviderBuilder(Boolean validationEnabled) { 
        this(new GitLabIdentityProvider(), validationEnabled);
    }


    public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitLabIdentityProvider(), validationEnabled);
    }


    public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,GitLabIdentityProvider instance) { 
        this(fluent, instance, true);
    }


    public GitLabIdentityProviderBuilder(GitLabIdentityProviderFluent<?> fluent,GitLabIdentityProvider instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCa(instance.getCa()); 
        fluent.withClientID(instance.getClientID()); 
        fluent.withClientSecret(instance.getClientSecret()); 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitLabIdentityProviderBuilder(GitLabIdentityProvider instance) { 
        this(instance,true);
    }


    public GitLabIdentityProviderBuilder(GitLabIdentityProvider instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCa(instance.getCa()); 
        this.withClientID(instance.getClientID()); 
        this.withClientSecret(instance.getClientSecret()); 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitLabIdentityProvider build() {
        GitLabIdentityProvider buildable = new GitLabIdentityProvider(fluent.getCa(),fluent.getClientID(),fluent.getClientSecret(),fluent.getUrl());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitLabIdentityProviderBuilder that = (GitLabIdentityProviderBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
