package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerNamedServingCertBuilder extends APIServerNamedServingCertFluentImpl<APIServerNamedServingCertBuilder> implements VisitableBuilder<APIServerNamedServingCert,APIServerNamedServingCertBuilder> {

    APIServerNamedServingCertFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerNamedServingCertBuilder() { 
        this(true);
    }


    public APIServerNamedServingCertBuilder(Boolean validationEnabled) { 
        this(new APIServerNamedServingCert(), validationEnabled);
    }


    public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent) { 
        this(fluent, true);
    }


    public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new APIServerNamedServingCert(), validationEnabled);
    }


    public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent,APIServerNamedServingCert instance) { 
        this(fluent, instance, true);
    }


    public APIServerNamedServingCertBuilder(APIServerNamedServingCertFluent<?> fluent,APIServerNamedServingCert instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withNames(instance.getNames()); 
        fluent.withServingCertificate(instance.getServingCertificate()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIServerNamedServingCertBuilder(APIServerNamedServingCert instance) { 
        this(instance,true);
    }


    public APIServerNamedServingCertBuilder(APIServerNamedServingCert instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withNames(instance.getNames()); 
        this.withServingCertificate(instance.getServingCertificate()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIServerNamedServingCert build() {
        APIServerNamedServingCert buildable = new APIServerNamedServingCert(fluent.getNames(),fluent.getServingCertificate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServerNamedServingCertBuilder that = (APIServerNamedServingCertBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
