package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class UpdateHistoryBuilder extends UpdateHistoryFluentImpl<UpdateHistoryBuilder> implements VisitableBuilder<UpdateHistory,UpdateHistoryBuilder>{

    UpdateHistoryFluent<?> fluent;
    Boolean validationEnabled;

    public UpdateHistoryBuilder(){
            this(true);
    }
    public UpdateHistoryBuilder(Boolean validationEnabled){
            this(new UpdateHistory(), validationEnabled);
    }
    public UpdateHistoryBuilder(UpdateHistoryFluent<?> fluent){
            this(fluent, true);
    }
    public UpdateHistoryBuilder(UpdateHistoryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new UpdateHistory(), validationEnabled);
    }
    public UpdateHistoryBuilder(UpdateHistoryFluent<?> fluent,UpdateHistory instance){
            this(fluent, instance, true);
    }
    public UpdateHistoryBuilder(UpdateHistoryFluent<?> fluent,UpdateHistory instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCompletionTime(instance.getCompletionTime()); 
            fluent.withImage(instance.getImage()); 
            fluent.withStartedTime(instance.getStartedTime()); 
            fluent.withState(instance.getState()); 
            fluent.withVerified(instance.getVerified()); 
            fluent.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public UpdateHistoryBuilder(UpdateHistory instance){
            this(instance,true);
    }
    public UpdateHistoryBuilder(UpdateHistory instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCompletionTime(instance.getCompletionTime()); 
            this.withImage(instance.getImage()); 
            this.withStartedTime(instance.getStartedTime()); 
            this.withState(instance.getState()); 
            this.withVerified(instance.getVerified()); 
            this.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public UpdateHistory build(){
            UpdateHistory buildable = new UpdateHistory(fluent.getCompletionTime(),fluent.getImage(),fluent.getStartedTime(),fluent.getState(),fluent.isVerified(),fluent.getVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            UpdateHistoryBuilder that = (UpdateHistoryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
