package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RequestHeaderIdentityProviderBuilder extends RequestHeaderIdentityProviderFluentImpl<RequestHeaderIdentityProviderBuilder> implements VisitableBuilder<RequestHeaderIdentityProvider,RequestHeaderIdentityProviderBuilder>{

    RequestHeaderIdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public RequestHeaderIdentityProviderBuilder(){
            this(true);
    }
    public RequestHeaderIdentityProviderBuilder(Boolean validationEnabled){
            this(new RequestHeaderIdentityProvider(), validationEnabled);
    }
    public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProviderFluent<?> fluent){
            this(fluent, true);
    }
    public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProviderFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RequestHeaderIdentityProvider(), validationEnabled);
    }
    public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProviderFluent<?> fluent,RequestHeaderIdentityProvider instance){
            this(fluent, instance, true);
    }
    public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProviderFluent<?> fluent,RequestHeaderIdentityProvider instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCa(instance.getCa()); 
            fluent.withChallengeURL(instance.getChallengeURL()); 
            fluent.withClientCommonNames(instance.getClientCommonNames()); 
            fluent.withEmailHeaders(instance.getEmailHeaders()); 
            fluent.withHeaders(instance.getHeaders()); 
            fluent.withLoginURL(instance.getLoginURL()); 
            fluent.withNameHeaders(instance.getNameHeaders()); 
            fluent.withPreferredUsernameHeaders(instance.getPreferredUsernameHeaders()); 
            this.validationEnabled = validationEnabled; 
    }
    public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProvider instance){
            this(instance,true);
    }
    public RequestHeaderIdentityProviderBuilder(RequestHeaderIdentityProvider instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCa(instance.getCa()); 
            this.withChallengeURL(instance.getChallengeURL()); 
            this.withClientCommonNames(instance.getClientCommonNames()); 
            this.withEmailHeaders(instance.getEmailHeaders()); 
            this.withHeaders(instance.getHeaders()); 
            this.withLoginURL(instance.getLoginURL()); 
            this.withNameHeaders(instance.getNameHeaders()); 
            this.withPreferredUsernameHeaders(instance.getPreferredUsernameHeaders()); 
            this.validationEnabled = validationEnabled; 
    }

    public RequestHeaderIdentityProvider build(){
            RequestHeaderIdentityProvider buildable = new RequestHeaderIdentityProvider(fluent.getCa(),fluent.getChallengeURL(),fluent.getClientCommonNames(),fluent.getEmailHeaders(),fluent.getHeaders(),fluent.getLoginURL(),fluent.getNameHeaders(),fluent.getPreferredUsernameHeaders());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RequestHeaderIdentityProviderBuilder that = (RequestHeaderIdentityProviderBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
