package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface OAuthSpecFluent<A extends OAuthSpecFluent<A>> extends Fluent<A>{


    public A addToIdentityProviders(int index,IdentityProvider item);
    public A setToIdentityProviders(int index,IdentityProvider item);
    public A addToIdentityProviders(IdentityProvider... items);
    public A addAllToIdentityProviders(Collection<IdentityProvider> items);
    public A removeFromIdentityProviders(IdentityProvider... items);
    public A removeAllFromIdentityProviders(Collection<IdentityProvider> items);
    public A removeMatchingFromIdentityProviders(io.fabric8.kubernetes.api.builder.Predicate<IdentityProviderBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildIdentityProviders instead.
 * @return The buildable object.
 */
@Deprecated public List<IdentityProvider> getIdentityProviders();
    public List<IdentityProvider> buildIdentityProviders();
    public IdentityProvider buildIdentityProvider(int index);
    public IdentityProvider buildFirstIdentityProvider();
    public IdentityProvider buildLastIdentityProvider();
    public IdentityProvider buildMatchingIdentityProvider(io.fabric8.kubernetes.api.builder.Predicate<IdentityProviderBuilder> predicate);
    public Boolean hasMatchingIdentityProvider(io.fabric8.kubernetes.api.builder.Predicate<IdentityProviderBuilder> predicate);
    public A withIdentityProviders(List<IdentityProvider> identityProviders);
    public A withIdentityProviders(IdentityProvider... identityProviders);
    public Boolean hasIdentityProviders();
    public OAuthSpecFluent.IdentityProvidersNested<A> addNewIdentityProvider();
    public OAuthSpecFluent.IdentityProvidersNested<A> addNewIdentityProviderLike(IdentityProvider item);
    public OAuthSpecFluent.IdentityProvidersNested<A> setNewIdentityProviderLike(int index,IdentityProvider item);
    public OAuthSpecFluent.IdentityProvidersNested<A> editIdentityProvider(int index);
    public OAuthSpecFluent.IdentityProvidersNested<A> editFirstIdentityProvider();
    public OAuthSpecFluent.IdentityProvidersNested<A> editLastIdentityProvider();
    public OAuthSpecFluent.IdentityProvidersNested<A> editMatchingIdentityProvider(io.fabric8.kubernetes.api.builder.Predicate<IdentityProviderBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTemplates instead.
 * @return The buildable object.
 */
@Deprecated public OAuthTemplates getTemplates();
    public OAuthTemplates buildTemplates();
    public A withTemplates(OAuthTemplates templates);
    public Boolean hasTemplates();
    public OAuthSpecFluent.TemplatesNested<A> withNewTemplates();
    public OAuthSpecFluent.TemplatesNested<A> withNewTemplatesLike(OAuthTemplates item);
    public OAuthSpecFluent.TemplatesNested<A> editTemplates();
    public OAuthSpecFluent.TemplatesNested<A> editOrNewTemplates();
    public OAuthSpecFluent.TemplatesNested<A> editOrNewTemplatesLike(OAuthTemplates item);
    
/**
 * This method has been deprecated, please use method buildTokenConfig instead.
 * @return The buildable object.
 */
@Deprecated public TokenConfig getTokenConfig();
    public TokenConfig buildTokenConfig();
    public A withTokenConfig(TokenConfig tokenConfig);
    public Boolean hasTokenConfig();
    public OAuthSpecFluent.TokenConfigNested<A> withNewTokenConfig();
    public OAuthSpecFluent.TokenConfigNested<A> withNewTokenConfigLike(TokenConfig item);
    public OAuthSpecFluent.TokenConfigNested<A> editTokenConfig();
    public OAuthSpecFluent.TokenConfigNested<A> editOrNewTokenConfig();
    public OAuthSpecFluent.TokenConfigNested<A> editOrNewTokenConfigLike(TokenConfig item);

    public interface IdentityProvidersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityProviderFluent<OAuthSpecFluent.IdentityProvidersNested<N>>{

        
    public N and();    public N endIdentityProvider();
}
    public interface TemplatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthTemplatesFluent<OAuthSpecFluent.TemplatesNested<N>>{

        
    public N and();    public N endTemplates();
}
    public interface TokenConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TokenConfigFluent<OAuthSpecFluent.TokenConfigNested<N>>{

        
    public N and();    public N endTokenConfig();
}


}
