package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthListBuilder extends OAuthListFluentImpl<OAuthListBuilder> implements VisitableBuilder<OAuthList,OAuthListBuilder>{

    OAuthListFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthListBuilder(){
            this(true);
    }
    public OAuthListBuilder(Boolean validationEnabled){
            this(new OAuthList(), validationEnabled);
    }
    public OAuthListBuilder(OAuthListFluent<?> fluent){
            this(fluent, true);
    }
    public OAuthListBuilder(OAuthListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OAuthList(), validationEnabled);
    }
    public OAuthListBuilder(OAuthListFluent<?> fluent,OAuthList instance){
            this(fluent, instance, true);
    }
    public OAuthListBuilder(OAuthListFluent<?> fluent,OAuthList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public OAuthListBuilder(OAuthList instance){
            this(instance,true);
    }
    public OAuthListBuilder(OAuthList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public OAuthList build(){
            OAuthList buildable = new OAuthList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OAuthListBuilder that = (OAuthListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
