package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ImageTagListFluent<A extends ImageTagListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ImageTag item);
    public A setToItems(int index,ImageTag item);
    public A addToItems(ImageTag... items);
    public A addAllToItems(Collection<ImageTag> items);
    public A removeFromItems(ImageTag... items);
    public A removeAllFromItems(Collection<ImageTag> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ImageTagBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ImageTag> getItems();
    public List<ImageTag> buildItems();
    public ImageTag buildItem(int index);
    public ImageTag buildFirstItem();
    public ImageTag buildLastItem();
    public ImageTag buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ImageTagBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ImageTagBuilder> predicate);
    public A withItems(List<ImageTag> items);
    public A withItems(ImageTag... items);
    public Boolean hasItems();
    public ImageTagListFluent.ItemsNested<A> addNewItem();
    public ImageTagListFluent.ItemsNested<A> addNewItemLike(ImageTag item);
    public ImageTagListFluent.ItemsNested<A> setNewItemLike(int index,ImageTag item);
    public ImageTagListFluent.ItemsNested<A> editItem(int index);
    public ImageTagListFluent.ItemsNested<A> editFirstItem();
    public ImageTagListFluent.ItemsNested<A> editLastItem();
    public ImageTagListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ImageTagBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageTagFluent<ImageTagListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
