package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class GCPPlatformStatusFluentImpl<A extends GCPPlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GCPPlatformStatusFluent<A>{

    private String projectID;
    private String region;

    public GCPPlatformStatusFluentImpl(){
    }
    public GCPPlatformStatusFluentImpl(GCPPlatformStatus instance){
            this.withProjectID(instance.getProjectID()); 
            this.withRegion(instance.getRegion()); 
    }

    public String getProjectID(){
            return this.projectID;
    }

    public A withProjectID(String projectID){
            this.projectID=projectID; return (A) this;
    }

    public Boolean hasProjectID(){
            return this.projectID != null;
    }

    public A withNewProjectID(String arg1){
            return (A)withProjectID(new String(arg1));
    }

    public A withNewProjectID(StringBuilder arg1){
            return (A)withProjectID(new String(arg1));
    }

    public A withNewProjectID(StringBuffer arg1){
            return (A)withProjectID(new String(arg1));
    }

    public String getRegion(){
            return this.region;
    }

    public A withRegion(String region){
            this.region=region; return (A) this;
    }

    public Boolean hasRegion(){
            return this.region != null;
    }

    public A withNewRegion(String arg1){
            return (A)withRegion(new String(arg1));
    }

    public A withNewRegion(StringBuilder arg1){
            return (A)withRegion(new String(arg1));
    }

    public A withNewRegion(StringBuffer arg1){
            return (A)withRegion(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            GCPPlatformStatusFluentImpl that = (GCPPlatformStatusFluentImpl) o;
            if (projectID != null ? !projectID.equals(that.projectID) :that.projectID != null) return false;
            if (region != null ? !region.equals(that.region) :that.region != null) return false;
            return true;
    }




}
