package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EgressNetworkPolicyListBuilder extends EgressNetworkPolicyListFluentImpl<EgressNetworkPolicyListBuilder> implements VisitableBuilder<EgressNetworkPolicyList,EgressNetworkPolicyListBuilder>{

    EgressNetworkPolicyListFluent<?> fluent;
    Boolean validationEnabled;

    public EgressNetworkPolicyListBuilder(){
            this(true);
    }
    public EgressNetworkPolicyListBuilder(Boolean validationEnabled){
            this(new EgressNetworkPolicyList(), validationEnabled);
    }
    public EgressNetworkPolicyListBuilder(EgressNetworkPolicyListFluent<?> fluent){
            this(fluent, true);
    }
    public EgressNetworkPolicyListBuilder(EgressNetworkPolicyListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EgressNetworkPolicyList(), validationEnabled);
    }
    public EgressNetworkPolicyListBuilder(EgressNetworkPolicyListFluent<?> fluent,EgressNetworkPolicyList instance){
            this(fluent, instance, true);
    }
    public EgressNetworkPolicyListBuilder(EgressNetworkPolicyListFluent<?> fluent,EgressNetworkPolicyList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public EgressNetworkPolicyListBuilder(EgressNetworkPolicyList instance){
            this(instance,true);
    }
    public EgressNetworkPolicyListBuilder(EgressNetworkPolicyList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public EgressNetworkPolicyList build(){
            EgressNetworkPolicyList buildable = new EgressNetworkPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EgressNetworkPolicyListBuilder that = (EgressNetworkPolicyListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
