package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class UpdateBuilder extends UpdateFluentImpl<UpdateBuilder> implements VisitableBuilder<Update,UpdateBuilder>{

    UpdateFluent<?> fluent;
    Boolean validationEnabled;

    public UpdateBuilder(){
            this(true);
    }
    public UpdateBuilder(Boolean validationEnabled){
            this(new Update(), validationEnabled);
    }
    public UpdateBuilder(UpdateFluent<?> fluent){
            this(fluent, true);
    }
    public UpdateBuilder(UpdateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Update(), validationEnabled);
    }
    public UpdateBuilder(UpdateFluent<?> fluent,Update instance){
            this(fluent, instance, true);
    }
    public UpdateBuilder(UpdateFluent<?> fluent,Update instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withForce(instance.getForce()); 
            fluent.withImage(instance.getImage()); 
            fluent.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public UpdateBuilder(Update instance){
            this(instance,true);
    }
    public UpdateBuilder(Update instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withForce(instance.getForce()); 
            this.withImage(instance.getImage()); 
            this.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public Update build(){
            Update buildable = new Update(fluent.isForce(),fluent.getImage(),fluent.getVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            UpdateBuilder that = (UpdateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
