package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface OperatorHubFluent<A extends OperatorHubFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public OperatorHubFluent.MetadataNested<A> withNewMetadata();
    public OperatorHubFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OperatorHubFluent.MetadataNested<A> editMetadata();
    public OperatorHubFluent.MetadataNested<A> editOrNewMetadata();
    public OperatorHubFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public OperatorHubSpec getSpec();
    public OperatorHubSpec buildSpec();
    public A withSpec(OperatorHubSpec spec);
    public Boolean hasSpec();
    public OperatorHubFluent.SpecNested<A> withNewSpec();
    public OperatorHubFluent.SpecNested<A> withNewSpecLike(OperatorHubSpec item);
    public OperatorHubFluent.SpecNested<A> editSpec();
    public OperatorHubFluent.SpecNested<A> editOrNewSpec();
    public OperatorHubFluent.SpecNested<A> editOrNewSpecLike(OperatorHubSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public OperatorHubStatus getStatus();
    public OperatorHubStatus buildStatus();
    public A withStatus(OperatorHubStatus status);
    public Boolean hasStatus();
    public OperatorHubFluent.StatusNested<A> withNewStatus();
    public OperatorHubFluent.StatusNested<A> withNewStatusLike(OperatorHubStatus item);
    public OperatorHubFluent.StatusNested<A> editStatus();
    public OperatorHubFluent.StatusNested<A> editOrNewStatus();
    public OperatorHubFluent.StatusNested<A> editOrNewStatusLike(OperatorHubStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OperatorHubFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorHubSpecFluent<OperatorHubFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorHubStatusFluent<OperatorHubFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
