package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EgressNetworkPolicySpecBuilder extends EgressNetworkPolicySpecFluentImpl<EgressNetworkPolicySpecBuilder> implements VisitableBuilder<EgressNetworkPolicySpec,EgressNetworkPolicySpecBuilder>{

    EgressNetworkPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public EgressNetworkPolicySpecBuilder(){
            this(true);
    }
    public EgressNetworkPolicySpecBuilder(Boolean validationEnabled){
            this(new EgressNetworkPolicySpec(), validationEnabled);
    }
    public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent){
            this(fluent, true);
    }
    public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EgressNetworkPolicySpec(), validationEnabled);
    }
    public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent,EgressNetworkPolicySpec instance){
            this(fluent, instance, true);
    }
    public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent,EgressNetworkPolicySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEgress(instance.getEgress()); 
            this.validationEnabled = validationEnabled; 
    }
    public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpec instance){
            this(instance,true);
    }
    public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEgress(instance.getEgress()); 
            this.validationEnabled = validationEnabled; 
    }

    public EgressNetworkPolicySpec build(){
            EgressNetworkPolicySpec buildable = new EgressNetworkPolicySpec(fluent.getEgress());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EgressNetworkPolicySpecBuilder that = (EgressNetworkPolicySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
