/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatch;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatchBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TunedMatchFluent<A extends TunedMatchFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String label;
    private ArrayList<TunedMatchBuilder> match = new ArrayList();
    private String type;
    private String value;

    public TunedMatchFluent() {
    }

    public TunedMatchFluent(TunedMatch instance) {
        this.copyInstance(instance);
    }

    public A addAllToMatch(Collection<TunedMatch> items) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        }
        return (A)((Object)this);
    }

    public MatchNested<A> addNewMatch() {
        return new MatchNested(-1, null);
    }

    public MatchNested<A> addNewMatchLike(TunedMatch item) {
        return new MatchNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMatch(TunedMatch ... items) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToMatch(int index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        if (index < 0 || index >= this.match.size()) {
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        } else {
            this._visitables.get((Object)"match").add(builder);
            this.match.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TunedMatch buildFirstMatch() {
        return this.match.get(0).build();
    }

    public TunedMatch buildLastMatch() {
        return this.match.get(this.match.size() - 1).build();
    }

    public List<TunedMatch> buildMatch() {
        return this.match != null ? TunedMatchFluent.build(this.match) : null;
    }

    public TunedMatch buildMatch(int index) {
        return this.match.get(index).build();
    }

    public TunedMatch buildMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(TunedMatch instance) {
        TunedMatch tunedMatch = instance = instance != null ? instance : new TunedMatch();
        if (instance != null) {
            this.withLabel(instance.getLabel());
            this.withMatch(instance.getMatch());
            this.withType(instance.getType());
            this.withValue(instance.getValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MatchNested<A> editFirstMatch() {
        if (this.match.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "match"));
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    public MatchNested<A> editLastMatch() {
        int index = this.match.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "match"));
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchNested<A> editMatch(int index) {
        if (this.match.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "match"));
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchNested<A> editMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.match.size(); ++i) {
            if (!predicate.test(this.match.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "match"));
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TunedMatchFluent that = (TunedMatchFluent)((Object)o);
        if (!Objects.equals(this.label, that.label)) {
            return false;
        }
        if (!Objects.equals(this.match, that.match)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    public boolean hasMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.match, this.type, this.value, this.additionalProperties);
    }

    public A removeAllFromMatch(Collection<TunedMatch> items) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").remove((Object)builder);
            this.match.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromMatch(TunedMatch ... items) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get((Object)"match").remove((Object)builder);
            this.match.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatch(Predicate<TunedMatchBuilder> predicate) {
        if (this.match == null) {
            return (A)((Object)this);
        }
        Iterator<TunedMatchBuilder> each = this.match.iterator();
        List visitables = this._visitables.get((Object)"match");
        while (each.hasNext()) {
            TunedMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public MatchNested<A> setNewMatchLike(int index, TunedMatch item) {
        return new MatchNested(index, item);
    }

    public A setToMatch(int index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        if (index < 0 || index >= this.match.size()) {
            this._visitables.get((Object)"match").add(builder);
            this.match.add(builder);
        } else {
            this._visitables.get((Object)"match").add(builder);
            this.match.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.label != null) {
            sb.append("label:");
            sb.append(this.label);
            sb.append(",");
        }
        if (this.match != null && !this.match.isEmpty()) {
            sb.append("match:");
            sb.append(this.match);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withLabel(String label) {
        this.label = label;
        return (A)((Object)this);
    }

    public A withMatch(List<TunedMatch> match) {
        if (this.match != null) {
            this._visitables.get((Object)"match").clear();
        }
        if (match != null) {
            this.match = new ArrayList();
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        } else {
            this.match = null;
        }
        return (A)((Object)this);
    }

    public A withMatch(TunedMatch ... match) {
        if (this.match != null) {
            this.match.clear();
            this._visitables.remove((Object)"match");
        }
        if (match != null) {
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        }
        return (A)((Object)this);
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public A withValue(String value) {
        this.value = value;
        return (A)((Object)this);
    }

    public class MatchNested<N>
    extends TunedMatchFluent<MatchNested<N>>
    implements Nested<N> {
        TunedMatchBuilder builder;
        int index;

        MatchNested(int index, TunedMatch item) {
            this.index = index;
            this.builder = new TunedMatchBuilder(this, item);
        }

        public N and() {
            return (N)TunedMatchFluent.this.setToMatch(this.index, this.builder.build());
        }

        public N endMatch() {
            return this.and();
        }
    }
}

