package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TunedMatchFluent<A extends TunedMatchFluent<A>> extends BaseFluent<A>{
  public TunedMatchFluent() {
  }
  
  public TunedMatchFluent(TunedMatch instance) {
    this.copyInstance(instance);
  }
  private String label;
  private ArrayList<TunedMatchBuilder> match = new ArrayList<TunedMatchBuilder>();
  private String type;
  private String value;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TunedMatch instance) {
    instance = (instance != null ? instance : new TunedMatch());
    if (instance != null) {
          this.withLabel(instance.getLabel());
          this.withMatch(instance.getMatch());
          this.withType(instance.getType());
          this.withValue(instance.getValue());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getLabel() {
    return this.label;
  }
  
  public A withLabel(String label) {
    this.label = label;
    return (A) this;
  }
  
  public boolean hasLabel() {
    return this.label != null;
  }
  
  public A addToMatch(int index,TunedMatch item) {
    if (this.match == null) {this.match = new ArrayList<TunedMatchBuilder>();}
    TunedMatchBuilder builder = new TunedMatchBuilder(item);
    if (index < 0 || index >= match.size()) { _visitables.get("match").add(builder); match.add(builder); } else { _visitables.get("match").add(index, builder); match.add(index, builder);}
    return (A)this;
  }
  
  public A setToMatch(int index,TunedMatch item) {
    if (this.match == null) {this.match = new ArrayList<TunedMatchBuilder>();}
    TunedMatchBuilder builder = new TunedMatchBuilder(item);
    if (index < 0 || index >= match.size()) { _visitables.get("match").add(builder); match.add(builder); } else { _visitables.get("match").set(index, builder); match.set(index, builder);}
    return (A)this;
  }
  
  public A addToMatch(io.fabric8.openshift.api.model.tuned.v1.TunedMatch... items) {
    if (this.match == null) {this.match = new ArrayList<TunedMatchBuilder>();}
    for (TunedMatch item : items) {TunedMatchBuilder builder = new TunedMatchBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  
  public A addAllToMatch(Collection<TunedMatch> items) {
    if (this.match == null) {this.match = new ArrayList<TunedMatchBuilder>();}
    for (TunedMatch item : items) {TunedMatchBuilder builder = new TunedMatchBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  
  public A removeFromMatch(io.fabric8.openshift.api.model.tuned.v1.TunedMatch... items) {
    if (this.match == null) return (A)this;
    for (TunedMatch item : items) {TunedMatchBuilder builder = new TunedMatchBuilder(item);_visitables.get("match").remove(builder); this.match.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMatch(Collection<TunedMatch> items) {
    if (this.match == null) return (A)this;
    for (TunedMatch item : items) {TunedMatchBuilder builder = new TunedMatchBuilder(item);_visitables.get("match").remove(builder); this.match.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMatch(Predicate<TunedMatchBuilder> predicate) {
    if (match == null) return (A) this;
    final Iterator<TunedMatchBuilder> each = match.iterator();
    final List visitables = _visitables.get("match");
    while (each.hasNext()) {
      TunedMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TunedMatch> buildMatch() {
    return this.match != null ? build(match) : null;
  }
  
  public TunedMatch buildMatch(int index) {
    return this.match.get(index).build();
  }
  
  public TunedMatch buildFirstMatch() {
    return this.match.get(0).build();
  }
  
  public TunedMatch buildLastMatch() {
    return this.match.get(match.size() - 1).build();
  }
  
  public TunedMatch buildMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
      for (TunedMatchBuilder item : match) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
      for (TunedMatchBuilder item : match) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMatch(List<TunedMatch> match) {
    if (this.match != null) {
      this._visitables.get("match").clear();
    }
    if (match != null) {
        this.match = new ArrayList();
        for (TunedMatch item : match) {
          this.addToMatch(item);
        }
    } else {
      this.match = null;
    }
    return (A) this;
  }
  
  public A withMatch(io.fabric8.openshift.api.model.tuned.v1.TunedMatch... match) {
    if (this.match != null) {
        this.match.clear();
        _visitables.remove("match");
    }
    if (match != null) {
      for (TunedMatch item : match) {
        this.addToMatch(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMatch() {
    return this.match != null && !this.match.isEmpty();
  }
  
  public MatchNested<A> addNewMatch() {
    return new MatchNested(-1, null);
  }
  
  public MatchNested<A> addNewMatchLike(TunedMatch item) {
    return new MatchNested(-1, item);
  }
  
  public MatchNested<A> setNewMatchLike(int index,TunedMatch item) {
    return new MatchNested(index, item);
  }
  
  public MatchNested<A> editMatch(int index) {
    if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  
  public MatchNested<A> editFirstMatch() {
    if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  
  public MatchNested<A> editLastMatch() {
    int index = match.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  
  public MatchNested<A> editMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<match.size();i++) { 
    if (predicate.test(match.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TunedMatchFluent that = (TunedMatchFluent) o;
    if (!java.util.Objects.equals(label, that.label)) return false;
    if (!java.util.Objects.equals(match, that.match)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(label,  match,  type,  value,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (label != null) { sb.append("label:"); sb.append(label + ","); }
    if (match != null && !match.isEmpty()) { sb.append("match:"); sb.append(match + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MatchNested<N> extends TunedMatchFluent<MatchNested<N>> implements Nested<N>{
    MatchNested(int index,TunedMatch item) {
      this.index = index;
      this.builder = new TunedMatchBuilder(this, item);
    }
    TunedMatchBuilder builder;
    int index;
    
    public N and() {
      return (N) TunedMatchFluent.this.setToMatch(index,builder.build());
    }
    
    public N endMatch() {
      return and();
    }
    
  
  }

}