package io.fabric8.openshift.api.model.tuned.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OperandConfigFluent<A extends OperandConfigFluent<A>> extends BaseFluent<A>{
  public OperandConfigFluent() {
  }
  
  public OperandConfigFluent(OperandConfig instance) {
    this.copyInstance(instance);
  }
  private Boolean debug;
  private TuneDConfigBuilder tunedConfig;
  private Integer verbosity;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OperandConfig instance) {
    instance = (instance != null ? instance : new OperandConfig());
    if (instance != null) {
          this.withDebug(instance.getDebug());
          this.withTunedConfig(instance.getTunedConfig());
          this.withVerbosity(instance.getVerbosity());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getDebug() {
    return this.debug;
  }
  
  public A withDebug(Boolean debug) {
    this.debug = debug;
    return (A) this;
  }
  
  public boolean hasDebug() {
    return this.debug != null;
  }
  
  public TuneDConfig buildTunedConfig() {
    return this.tunedConfig != null ? this.tunedConfig.build() : null;
  }
  
  public A withTunedConfig(TuneDConfig tunedConfig) {
    this._visitables.remove("tunedConfig");
    if (tunedConfig != null) {
        this.tunedConfig = new TuneDConfigBuilder(tunedConfig);
        this._visitables.get("tunedConfig").add(this.tunedConfig);
    } else {
        this.tunedConfig = null;
        this._visitables.get("tunedConfig").remove(this.tunedConfig);
    }
    return (A) this;
  }
  
  public boolean hasTunedConfig() {
    return this.tunedConfig != null;
  }
  
  public A withNewTunedConfig(Boolean reapplySysctl) {
    return (A)withTunedConfig(new TuneDConfig(reapplySysctl));
  }
  
  public TunedConfigNested<A> withNewTunedConfig() {
    return new TunedConfigNested(null);
  }
  
  public TunedConfigNested<A> withNewTunedConfigLike(TuneDConfig item) {
    return new TunedConfigNested(item);
  }
  
  public TunedConfigNested<A> editTunedConfig() {
    return withNewTunedConfigLike(java.util.Optional.ofNullable(buildTunedConfig()).orElse(null));
  }
  
  public TunedConfigNested<A> editOrNewTunedConfig() {
    return withNewTunedConfigLike(java.util.Optional.ofNullable(buildTunedConfig()).orElse(new TuneDConfigBuilder().build()));
  }
  
  public TunedConfigNested<A> editOrNewTunedConfigLike(TuneDConfig item) {
    return withNewTunedConfigLike(java.util.Optional.ofNullable(buildTunedConfig()).orElse(item));
  }
  
  public Integer getVerbosity() {
    return this.verbosity;
  }
  
  public A withVerbosity(Integer verbosity) {
    this.verbosity = verbosity;
    return (A) this;
  }
  
  public boolean hasVerbosity() {
    return this.verbosity != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OperandConfigFluent that = (OperandConfigFluent) o;
    if (!java.util.Objects.equals(debug, that.debug)) return false;
    if (!java.util.Objects.equals(tunedConfig, that.tunedConfig)) return false;
    if (!java.util.Objects.equals(verbosity, that.verbosity)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(debug,  tunedConfig,  verbosity,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (debug != null) { sb.append("debug:"); sb.append(debug + ","); }
    if (tunedConfig != null) { sb.append("tunedConfig:"); sb.append(tunedConfig + ","); }
    if (verbosity != null) { sb.append("verbosity:"); sb.append(verbosity + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDebug() {
    return withDebug(true);
  }
  public class TunedConfigNested<N> extends TuneDConfigFluent<TunedConfigNested<N>> implements Nested<N>{
    TunedConfigNested(TuneDConfig item) {
      this.builder = new TuneDConfigBuilder(this, item);
    }
    TuneDConfigBuilder builder;
    
    public N and() {
      return (N) OperandConfigFluent.this.withTunedConfig(builder.build());
    }
    
    public N endTunedConfig() {
      return and();
    }
    
  
  }

}