package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface TunedListFluent<A extends TunedListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,Tuned item);
  public A setToItems(int index,Tuned item);
  public A addToItems(io.fabric8.openshift.api.model.tuned.v1.Tuned... items);
  public A addAllToItems(Collection<Tuned> items);
  public A removeFromItems(io.fabric8.openshift.api.model.tuned.v1.Tuned... items);
  public A removeAllFromItems(Collection<Tuned> items);
  public A removeMatchingFromItems(Predicate<TunedBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Tuned> getItems();
  public List<Tuned> buildItems();
  public Tuned buildItem(int index);
  public Tuned buildFirstItem();
  public Tuned buildLastItem();
  public Tuned buildMatchingItem(Predicate<TunedBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<TunedBuilder> predicate);
  public A withItems(List<Tuned> items);
  public A withItems(io.fabric8.openshift.api.model.tuned.v1.Tuned... items);
  public Boolean hasItems();
  public TunedListFluent.ItemsNested<A> addNewItem();
  public TunedListFluent.ItemsNested<A> addNewItemLike(Tuned item);
  public TunedListFluent.ItemsNested<A> setNewItemLike(int index,Tuned item);
  public TunedListFluent.ItemsNested<A> editItem(int index);
  public TunedListFluent.ItemsNested<A> editFirstItem();
  public TunedListFluent.ItemsNested<A> editLastItem();
  public TunedListFluent.ItemsNested<A> editMatchingItem(Predicate<TunedBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,TunedFluent<TunedListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}