package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TunedListBuilder extends TunedListFluentImpl<TunedListBuilder> implements VisitableBuilder<TunedList,TunedListBuilder>{
  public TunedListBuilder() {
    this(false);
  }
  public TunedListBuilder(Boolean validationEnabled) {
    this(new TunedList(), validationEnabled);
  }
  public TunedListBuilder(TunedListFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedListBuilder(TunedListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TunedList(), validationEnabled);
  }
  public TunedListBuilder(TunedListFluent<?> fluent,TunedList instance) {
    this(fluent, instance, false);
  }
  public TunedListBuilder(TunedListFluent<?> fluent,TunedList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TunedListBuilder(TunedList instance) {
    this(instance,false);
  }
  public TunedListBuilder(TunedList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TunedListFluent<?> fluent;
  Boolean validationEnabled;
  public TunedList build() {
    TunedList buildable = new TunedList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}