package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface TunedFluent<A extends TunedFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public TunedFluent.MetadataNested<A> withNewMetadata();
  public TunedFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public TunedFluent.MetadataNested<A> editMetadata();
  public TunedFluent.MetadataNested<A> editOrNewMetadata();
  public TunedFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public TunedSpec getSpec();
  public TunedSpec buildSpec();
  public A withSpec(TunedSpec spec);
  public Boolean hasSpec();
  public TunedFluent.SpecNested<A> withNewSpec();
  public TunedFluent.SpecNested<A> withNewSpecLike(TunedSpec item);
  public TunedFluent.SpecNested<A> editSpec();
  public TunedFluent.SpecNested<A> editOrNewSpec();
  public TunedFluent.SpecNested<A> editOrNewSpecLike(TunedSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public TunedStatus getStatus();
  public TunedStatus buildStatus();
  public A withStatus(TunedStatus status);
  public Boolean hasStatus();
  public TunedFluent.StatusNested<A> withNewStatus();
  public TunedFluent.StatusNested<A> withNewStatusLike(TunedStatus item);
  public TunedFluent.StatusNested<A> editStatus();
  public TunedFluent.StatusNested<A> editOrNewStatus();
  public TunedFluent.StatusNested<A> editOrNewStatusLike(TunedStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<TunedFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,TunedSpecFluent<TunedFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,TunedStatusFluent<TunedFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}