package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TunedListBuilder extends TunedListFluent<TunedListBuilder> implements VisitableBuilder<TunedList,TunedListBuilder>{
  public TunedListBuilder() {
    this(new TunedList());
  }
  
  public TunedListBuilder(TunedListFluent<?> fluent) {
    this(fluent, new TunedList());
  }
  
  public TunedListBuilder(TunedListFluent<?> fluent,TunedList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TunedListBuilder(TunedList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TunedListFluent<?> fluent;
  
  public TunedList build() {
    TunedList buildable = new TunedList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}