package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TunedRecommendBuilder extends TunedRecommendFluent<TunedRecommendBuilder> implements VisitableBuilder<TunedRecommend,TunedRecommendBuilder>{
  public TunedRecommendBuilder() {
    this(new TunedRecommend());
  }
  
  public TunedRecommendBuilder(TunedRecommendFluent<?> fluent) {
    this(fluent, new TunedRecommend());
  }
  
  public TunedRecommendBuilder(TunedRecommendFluent<?> fluent,TunedRecommend instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TunedRecommendBuilder(TunedRecommend instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TunedRecommendFluent<?> fluent;
  
  public TunedRecommend build() {
    TunedRecommend buildable = new TunedRecommend(fluent.getMachineConfigLabels(),fluent.buildMatch(),fluent.buildOperand(),fluent.getPriority(),fluent.getProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}