package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageVersionMigrationStatusBuilder extends StorageVersionMigrationStatusFluentImpl<StorageVersionMigrationStatusBuilder> implements VisitableBuilder<StorageVersionMigrationStatus,StorageVersionMigrationStatusBuilder>{
  public StorageVersionMigrationStatusBuilder() {
    this(false);
  }
  public StorageVersionMigrationStatusBuilder(Boolean validationEnabled) {
    this(new StorageVersionMigrationStatus(), validationEnabled);
  }
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageVersionMigrationStatus(), validationEnabled);
  }
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatusFluent<?> fluent,StorageVersionMigrationStatus instance) {
    this(fluent, instance, false);
  }
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatusFluent<?> fluent,StorageVersionMigrationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatus instance) {
    this(instance,false);
  }
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageVersionMigrationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public StorageVersionMigrationStatus build() {
    StorageVersionMigrationStatus buildable = new StorageVersionMigrationStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}