package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StorageStateStatusFluentImpl<A extends StorageStateStatusFluent<A>> extends BaseFluent<A> implements StorageStateStatusFluent<A>{
  public StorageStateStatusFluentImpl() {
  }
  public StorageStateStatusFluentImpl(StorageStateStatus instance) {
    if (instance != null) {
      this.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash());
      this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
      this.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String currentStorageVersionHash;
  private String lastHeartbeatTime;
  private List<String> persistedStorageVersionHashes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getCurrentStorageVersionHash() {
    return this.currentStorageVersionHash;
  }
  public A withCurrentStorageVersionHash(String currentStorageVersionHash) {
    this.currentStorageVersionHash=currentStorageVersionHash; return (A) this;
  }
  public Boolean hasCurrentStorageVersionHash() {
    return this.currentStorageVersionHash != null;
  }
  public String getLastHeartbeatTime() {
    return this.lastHeartbeatTime;
  }
  public A withLastHeartbeatTime(String lastHeartbeatTime) {
    this.lastHeartbeatTime=lastHeartbeatTime; return (A) this;
  }
  public Boolean hasLastHeartbeatTime() {
    return this.lastHeartbeatTime != null;
  }
  public A addToPersistedStorageVersionHashes(int index,String item) {
    if (this.persistedStorageVersionHashes == null) {this.persistedStorageVersionHashes = new ArrayList<String>();}
    this.persistedStorageVersionHashes.add(index, item);
    return (A)this;
  }
  public A setToPersistedStorageVersionHashes(int index,String item) {
    if (this.persistedStorageVersionHashes == null) {this.persistedStorageVersionHashes = new ArrayList<String>();}
    this.persistedStorageVersionHashes.set(index, item); return (A)this;
  }
  public A addToPersistedStorageVersionHashes(java.lang.String... items) {
    if (this.persistedStorageVersionHashes == null) {this.persistedStorageVersionHashes = new ArrayList<String>();}
    for (String item : items) {this.persistedStorageVersionHashes.add(item);} return (A)this;
  }
  public A addAllToPersistedStorageVersionHashes(Collection<String> items) {
    if (this.persistedStorageVersionHashes == null) {this.persistedStorageVersionHashes = new ArrayList<String>();}
    for (String item : items) {this.persistedStorageVersionHashes.add(item);} return (A)this;
  }
  public A removeFromPersistedStorageVersionHashes(java.lang.String... items) {
    for (String item : items) {if (this.persistedStorageVersionHashes!= null){ this.persistedStorageVersionHashes.remove(item);}} return (A)this;
  }
  public A removeAllFromPersistedStorageVersionHashes(Collection<String> items) {
    for (String item : items) {if (this.persistedStorageVersionHashes!= null){ this.persistedStorageVersionHashes.remove(item);}} return (A)this;
  }
  public List<String> getPersistedStorageVersionHashes() {
    return this.persistedStorageVersionHashes;
  }
  public String getPersistedStorageVersionHash(int index) {
    return this.persistedStorageVersionHashes.get(index);
  }
  public String getFirstPersistedStorageVersionHash() {
    return this.persistedStorageVersionHashes.get(0);
  }
  public String getLastPersistedStorageVersionHash() {
    return this.persistedStorageVersionHashes.get(persistedStorageVersionHashes.size() - 1);
  }
  public String getMatchingPersistedStorageVersionHash(Predicate<String> predicate) {
    for (String item: persistedStorageVersionHashes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPersistedStorageVersionHash(Predicate<String> predicate) {
    for (String item: persistedStorageVersionHashes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPersistedStorageVersionHashes(List<String> persistedStorageVersionHashes) {
    if (persistedStorageVersionHashes != null) {this.persistedStorageVersionHashes = new ArrayList(); for (String item : persistedStorageVersionHashes){this.addToPersistedStorageVersionHashes(item);}} else { this.persistedStorageVersionHashes = null;} return (A) this;
  }
  public A withPersistedStorageVersionHashes(java.lang.String... persistedStorageVersionHashes) {
    if (this.persistedStorageVersionHashes != null) {this.persistedStorageVersionHashes.clear(); _visitables.remove("persistedStorageVersionHashes"); }
    if (persistedStorageVersionHashes != null) {for (String item :persistedStorageVersionHashes){ this.addToPersistedStorageVersionHashes(item);}} return (A) this;
  }
  public Boolean hasPersistedStorageVersionHashes() {
    return persistedStorageVersionHashes != null && !persistedStorageVersionHashes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StorageStateStatusFluentImpl that = (StorageStateStatusFluentImpl) o;
    if (!java.util.Objects.equals(currentStorageVersionHash, that.currentStorageVersionHash)) return false;

    if (!java.util.Objects.equals(lastHeartbeatTime, that.lastHeartbeatTime)) return false;

    if (!java.util.Objects.equals(persistedStorageVersionHashes, that.persistedStorageVersionHashes)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(currentStorageVersionHash,  lastHeartbeatTime,  persistedStorageVersionHashes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (currentStorageVersionHash != null) { sb.append("currentStorageVersionHash:"); sb.append(currentStorageVersionHash + ","); }
    if (lastHeartbeatTime != null) { sb.append("lastHeartbeatTime:"); sb.append(lastHeartbeatTime + ","); }
    if (persistedStorageVersionHashes != null && !persistedStorageVersionHashes.isEmpty()) { sb.append("persistedStorageVersionHashes:"); sb.append(persistedStorageVersionHashes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}