package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageStateListBuilder extends StorageStateListFluentImpl<StorageStateListBuilder> implements VisitableBuilder<StorageStateList,StorageStateListBuilder>{
  public StorageStateListBuilder() {
    this(false);
  }
  public StorageStateListBuilder(Boolean validationEnabled) {
    this(new StorageStateList(), validationEnabled);
  }
  public StorageStateListBuilder(StorageStateListFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageStateListBuilder(StorageStateListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageStateList(), validationEnabled);
  }
  public StorageStateListBuilder(StorageStateListFluent<?> fluent,StorageStateList instance) {
    this(fluent, instance, false);
  }
  public StorageStateListBuilder(StorageStateListFluent<?> fluent,StorageStateList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageStateListBuilder(StorageStateList instance) {
    this(instance,false);
  }
  public StorageStateListBuilder(StorageStateList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageStateListFluent<?> fluent;
  Boolean validationEnabled;
  public StorageStateList build() {
    StorageStateList buildable = new StorageStateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}