package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupResourceBuilder extends GroupResourceFluentImpl<GroupResourceBuilder> implements VisitableBuilder<GroupResource,GroupResourceBuilder>{
  public GroupResourceBuilder() {
    this(false);
  }
  public GroupResourceBuilder(Boolean validationEnabled) {
    this(new GroupResource(), validationEnabled);
  }
  public GroupResourceBuilder(GroupResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupResourceBuilder(GroupResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GroupResource(), validationEnabled);
  }
  public GroupResourceBuilder(GroupResourceFluent<?> fluent,GroupResource instance) {
    this(fluent, instance, false);
  }
  public GroupResourceBuilder(GroupResourceFluent<?> fluent,GroupResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withResource(instance.getResource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GroupResourceBuilder(GroupResource instance) {
    this(instance,false);
  }
  public GroupResourceBuilder(GroupResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withResource(instance.getResource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GroupResourceFluent<?> fluent;
  Boolean validationEnabled;
  public GroupResource build() {
    GroupResource buildable = new GroupResource(fluent.getGroup(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}