/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ActionDescriptorFluent<A extends ActionDescriptorFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String description;
    private String displayName;
    private String path;
    private String value;
    private List<String> xDescriptors = new ArrayList<String>();

    public ActionDescriptorFluent() {
    }

    public ActionDescriptorFluent(ActionDescriptor instance) {
        this.copyInstance(instance);
    }

    public A addAllToXDescriptors(Collection<String> items) {
        if (this.xDescriptors == null) {
            this.xDescriptors = new ArrayList<String>();
        }
        for (String item : items) {
            this.xDescriptors.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToXDescriptors(String ... items) {
        if (this.xDescriptors == null) {
            this.xDescriptors = new ArrayList<String>();
        }
        for (String item : items) {
            this.xDescriptors.add(item);
        }
        return (A)((Object)this);
    }

    public A addToXDescriptors(int index, String item) {
        if (this.xDescriptors == null) {
            this.xDescriptors = new ArrayList<String>();
        }
        this.xDescriptors.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(ActionDescriptor instance) {
        ActionDescriptor actionDescriptor = instance = instance != null ? instance : new ActionDescriptor();
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withDisplayName(instance.getDisplayName());
            this.withPath(instance.getPath());
            this.withValue(instance.getValue());
            this.withXDescriptors(instance.getXDescriptors());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActionDescriptorFluent that = (ActionDescriptorFluent)((Object)o);
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        if (!Objects.equals(this.xDescriptors, that.xDescriptors)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFirstXDescriptor() {
        return this.xDescriptors.get(0);
    }

    public String getLastXDescriptor() {
        return this.xDescriptors.get(this.xDescriptors.size() - 1);
    }

    public String getMatchingXDescriptor(Predicate<String> predicate) {
        for (String item : this.xDescriptors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public String getXDescriptor(int index) {
        return this.xDescriptors.get(index);
    }

    public List<String> getXDescriptors() {
        return this.xDescriptors;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public boolean hasMatchingXDescriptor(Predicate<String> predicate) {
        for (String item : this.xDescriptors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean hasXDescriptors() {
        return this.xDescriptors != null && !this.xDescriptors.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.description, this.displayName, this.path, this.value, this.xDescriptors, this.additionalProperties);
    }

    public A removeAllFromXDescriptors(Collection<String> items) {
        if (this.xDescriptors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.xDescriptors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromXDescriptors(String ... items) {
        if (this.xDescriptors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.xDescriptors.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToXDescriptors(int index, String item) {
        if (this.xDescriptors == null) {
            this.xDescriptors = new ArrayList<String>();
        }
        this.xDescriptors.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description);
            sb.append(",");
        }
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName);
            sb.append(",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path);
            sb.append(",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
            sb.append(",");
        }
        if (this.xDescriptors != null && !this.xDescriptors.isEmpty()) {
            sb.append("xDescriptors:");
            sb.append(this.xDescriptors);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)((Object)this);
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public A withValue(String value) {
        this.value = value;
        return (A)((Object)this);
    }

    public A withXDescriptors(List<String> xDescriptors) {
        if (xDescriptors != null) {
            this.xDescriptors = new ArrayList<String>();
            for (String item : xDescriptors) {
                this.addToXDescriptors(item);
            }
        } else {
            this.xDescriptors = null;
        }
        return (A)((Object)this);
    }

    public A withXDescriptors(String ... xDescriptors) {
        if (this.xDescriptors != null) {
            this.xDescriptors.clear();
            this._visitables.remove((Object)"xDescriptors");
        }
        if (xDescriptors != null) {
            for (String item : xDescriptors) {
                this.addToXDescriptors(item);
            }
        }
        return (A)((Object)this);
    }
}

