package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InstallPlanStatusBuilder extends InstallPlanStatusFluentImpl<InstallPlanStatusBuilder> implements VisitableBuilder<InstallPlanStatus,InstallPlanStatusBuilder>{
  public InstallPlanStatusBuilder() {
    this(false);
  }
  public InstallPlanStatusBuilder(Boolean validationEnabled) {
    this(new InstallPlanStatus(), validationEnabled);
  }
  public InstallPlanStatusBuilder(InstallPlanStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public InstallPlanStatusBuilder(InstallPlanStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InstallPlanStatus(), validationEnabled);
  }
  public InstallPlanStatusBuilder(InstallPlanStatusFluent<?> fluent,InstallPlanStatus instance) {
    this(fluent, instance, false);
  }
  public InstallPlanStatusBuilder(InstallPlanStatusFluent<?> fluent,InstallPlanStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAttenuatedServiceAccountRef(instance.getAttenuatedServiceAccountRef());
      fluent.withBundleLookups(instance.getBundleLookups());
      fluent.withCatalogSources(instance.getCatalogSources());
      fluent.withConditions(instance.getConditions());
      fluent.withMessage(instance.getMessage());
      fluent.withPhase(instance.getPhase());
      fluent.withPlan(instance.getPlan());
      fluent.withStartTime(instance.getStartTime());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InstallPlanStatusBuilder(InstallPlanStatus instance) {
    this(instance,false);
  }
  public InstallPlanStatusBuilder(InstallPlanStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAttenuatedServiceAccountRef(instance.getAttenuatedServiceAccountRef());
      this.withBundleLookups(instance.getBundleLookups());
      this.withCatalogSources(instance.getCatalogSources());
      this.withConditions(instance.getConditions());
      this.withMessage(instance.getMessage());
      this.withPhase(instance.getPhase());
      this.withPlan(instance.getPlan());
      this.withStartTime(instance.getStartTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  InstallPlanStatusFluent<?> fluent;
  Boolean validationEnabled;
  public InstallPlanStatus build() {
    InstallPlanStatus buildable = new InstallPlanStatus(fluent.getAttenuatedServiceAccountRef(),fluent.getBundleLookups(),fluent.getCatalogSources(),fluent.getConditions(),fluent.getMessage(),fluent.getPhase(),fluent.getPlan(),fluent.getStartTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}