package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InstallPlanListBuilder extends InstallPlanListFluentImpl<InstallPlanListBuilder> implements VisitableBuilder<InstallPlanList,InstallPlanListBuilder>{
  public InstallPlanListBuilder() {
    this(false);
  }
  public InstallPlanListBuilder(Boolean validationEnabled) {
    this(new InstallPlanList(), validationEnabled);
  }
  public InstallPlanListBuilder(InstallPlanListFluent<?> fluent) {
    this(fluent, false);
  }
  public InstallPlanListBuilder(InstallPlanListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InstallPlanList(), validationEnabled);
  }
  public InstallPlanListBuilder(InstallPlanListFluent<?> fluent,InstallPlanList instance) {
    this(fluent, instance, false);
  }
  public InstallPlanListBuilder(InstallPlanListFluent<?> fluent,InstallPlanList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InstallPlanListBuilder(InstallPlanList instance) {
    this(instance,false);
  }
  public InstallPlanListBuilder(InstallPlanList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  InstallPlanListFluent<?> fluent;
  Boolean validationEnabled;
  public InstallPlanList build() {
    InstallPlanList buildable = new InstallPlanList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}