package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceVersionListBuilder extends ClusterServiceVersionListFluentImpl<ClusterServiceVersionListBuilder> implements VisitableBuilder<ClusterServiceVersionList,ClusterServiceVersionListBuilder>{
  public ClusterServiceVersionListBuilder() {
    this(false);
  }
  public ClusterServiceVersionListBuilder(Boolean validationEnabled) {
    this(new ClusterServiceVersionList(), validationEnabled);
  }
  public ClusterServiceVersionListBuilder(ClusterServiceVersionListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceVersionListBuilder(ClusterServiceVersionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceVersionList(), validationEnabled);
  }
  public ClusterServiceVersionListBuilder(ClusterServiceVersionListFluent<?> fluent,ClusterServiceVersionList instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceVersionListBuilder(ClusterServiceVersionListFluent<?> fluent,ClusterServiceVersionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceVersionListBuilder(ClusterServiceVersionList instance) {
    this(instance,false);
  }
  public ClusterServiceVersionListBuilder(ClusterServiceVersionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceVersionListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceVersionList build() {
    ClusterServiceVersionList buildable = new ClusterServiceVersionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}