package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceVersionConditionBuilder extends ClusterServiceVersionConditionFluentImpl<ClusterServiceVersionConditionBuilder> implements VisitableBuilder<ClusterServiceVersionCondition,ClusterServiceVersionConditionBuilder>{
  public ClusterServiceVersionConditionBuilder() {
    this(false);
  }
  public ClusterServiceVersionConditionBuilder(Boolean validationEnabled) {
    this(new ClusterServiceVersionCondition(), validationEnabled);
  }
  public ClusterServiceVersionConditionBuilder(ClusterServiceVersionConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceVersionConditionBuilder(ClusterServiceVersionConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceVersionCondition(), validationEnabled);
  }
  public ClusterServiceVersionConditionBuilder(ClusterServiceVersionConditionFluent<?> fluent,ClusterServiceVersionCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceVersionConditionBuilder(ClusterServiceVersionConditionFluent<?> fluent,ClusterServiceVersionCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withPhase(instance.getPhase());
      fluent.withReason(instance.getReason());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceVersionConditionBuilder(ClusterServiceVersionCondition instance) {
    this(instance,false);
  }
  public ClusterServiceVersionConditionBuilder(ClusterServiceVersionCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withPhase(instance.getPhase());
      this.withReason(instance.getReason());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceVersionConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceVersionCondition build() {
    ClusterServiceVersionCondition buildable = new ClusterServiceVersionCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getPhase(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}