package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BundleLookupFluentImpl<A extends BundleLookupFluent<A>> extends BaseFluent<A> implements BundleLookupFluent<A>{
  public BundleLookupFluentImpl() {
  }
  public BundleLookupFluentImpl(BundleLookup instance) {
    if (instance != null) {
      this.withCatalogSourceRef(instance.getCatalogSourceRef());
      this.withConditions(instance.getConditions());
      this.withIdentifier(instance.getIdentifier());
      this.withPath(instance.getPath());
      this.withProperties(instance.getProperties());
      this.withReplaces(instance.getReplaces());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ObjectReferenceBuilder catalogSourceRef;
  private ArrayList<BundleLookupConditionBuilder> conditions = new ArrayList<BundleLookupConditionBuilder>();
  private String identifier;
  private String path;
  private String properties;
  private String replaces;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCatalogSourceRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getCatalogSourceRef() {
    return this.catalogSourceRef!=null ?this.catalogSourceRef.build():null;
  }
  public ObjectReference buildCatalogSourceRef() {
    return this.catalogSourceRef!=null ?this.catalogSourceRef.build():null;
  }
  public A withCatalogSourceRef(ObjectReference catalogSourceRef) {
    _visitables.get("catalogSourceRef").remove(this.catalogSourceRef);
    if (catalogSourceRef!=null){ this.catalogSourceRef= new ObjectReferenceBuilder(catalogSourceRef); _visitables.get("catalogSourceRef").add(this.catalogSourceRef);} else { this.catalogSourceRef = null; _visitables.get("catalogSourceRef").remove(this.catalogSourceRef); } return (A) this;
  }
  public Boolean hasCatalogSourceRef() {
    return this.catalogSourceRef != null;
  }
  public BundleLookupFluentImpl.CatalogSourceRefNested<A> withNewCatalogSourceRef() {
    return new BundleLookupFluentImpl.CatalogSourceRefNestedImpl();
  }
  public BundleLookupFluentImpl.CatalogSourceRefNested<A> withNewCatalogSourceRefLike(ObjectReference item) {
    return new BundleLookupFluentImpl.CatalogSourceRefNestedImpl(item);
  }
  public BundleLookupFluentImpl.CatalogSourceRefNested<A> editCatalogSourceRef() {
    return withNewCatalogSourceRefLike(getCatalogSourceRef());
  }
  public BundleLookupFluentImpl.CatalogSourceRefNested<A> editOrNewCatalogSourceRef() {
    return withNewCatalogSourceRefLike(getCatalogSourceRef() != null ? getCatalogSourceRef(): new ObjectReferenceBuilder().build());
  }
  public BundleLookupFluentImpl.CatalogSourceRefNested<A> editOrNewCatalogSourceRefLike(ObjectReference item) {
    return withNewCatalogSourceRefLike(getCatalogSourceRef() != null ? getCatalogSourceRef(): item);
  }
  public A addToConditions(int index,BundleLookupCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>();}
    BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,BundleLookupCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>();}
    BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>();}
    for (BundleLookupCondition item : items) {BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<BundleLookupCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<BundleLookupConditionBuilder>();}
    for (BundleLookupCondition item : items) {BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupCondition... items) {
    for (BundleLookupCondition item : items) {BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<BundleLookupCondition> items) {
    for (BundleLookupCondition item : items) {BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<BundleLookupConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<BundleLookupConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      BundleLookupConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BundleLookupCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<BundleLookupCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public BundleLookupCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public BundleLookupCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public BundleLookupCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public BundleLookupCondition buildMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
    for (BundleLookupConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
    for (BundleLookupConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<BundleLookupCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (BundleLookupCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (BundleLookupCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public BundleLookupFluentImpl.ConditionsNested<A> addNewCondition() {
    return new BundleLookupFluentImpl.ConditionsNestedImpl();
  }
  public BundleLookupFluentImpl.ConditionsNested<A> addNewConditionLike(BundleLookupCondition item) {
    return new BundleLookupFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public BundleLookupFluentImpl.ConditionsNested<A> setNewConditionLike(int index,BundleLookupCondition item) {
    return new BundleLookupFluentImpl.ConditionsNestedImpl(index, item);
  }
  public BundleLookupFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public BundleLookupFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public BundleLookupFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public BundleLookupFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getIdentifier() {
    return this.identifier;
  }
  public A withIdentifier(String identifier) {
    this.identifier=identifier; return (A) this;
  }
  public Boolean hasIdentifier() {
    return this.identifier != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public String getProperties() {
    return this.properties;
  }
  public A withProperties(String properties) {
    this.properties=properties; return (A) this;
  }
  public Boolean hasProperties() {
    return this.properties != null;
  }
  public String getReplaces() {
    return this.replaces;
  }
  public A withReplaces(String replaces) {
    this.replaces=replaces; return (A) this;
  }
  public Boolean hasReplaces() {
    return this.replaces != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BundleLookupFluentImpl that = (BundleLookupFluentImpl) o;
    if (!java.util.Objects.equals(catalogSourceRef, that.catalogSourceRef)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(identifier, that.identifier)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(properties, that.properties)) return false;

    if (!java.util.Objects.equals(replaces, that.replaces)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(catalogSourceRef,  conditions,  identifier,  path,  properties,  replaces,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (catalogSourceRef != null) { sb.append("catalogSourceRef:"); sb.append(catalogSourceRef + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (identifier != null) { sb.append("identifier:"); sb.append(identifier + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (properties != null) { sb.append("properties:"); sb.append(properties + ","); }
    if (replaces != null) { sb.append("replaces:"); sb.append(replaces + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CatalogSourceRefNestedImpl<N> extends ObjectReferenceFluentImpl<BundleLookupFluentImpl.CatalogSourceRefNested<N>> implements BundleLookupFluentImpl.CatalogSourceRefNested<N>,Nested<N>{
    CatalogSourceRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    CatalogSourceRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BundleLookupFluentImpl.this.withCatalogSourceRef(builder.build());
    }
    public N endCatalogSourceRef() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends BundleLookupConditionFluentImpl<BundleLookupFluentImpl.ConditionsNested<N>> implements BundleLookupFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,BundleLookupCondition item) {
      this.index = index;
      this.builder = new BundleLookupConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new BundleLookupConditionBuilder(this);
    }
    BundleLookupConditionBuilder builder;
    int index;
    public N and() {
      return (N) BundleLookupFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}