package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BundleLookupBuilder extends BundleLookupFluentImpl<BundleLookupBuilder> implements VisitableBuilder<BundleLookup,BundleLookupBuilder>{
  public BundleLookupBuilder() {
    this(false);
  }
  public BundleLookupBuilder(Boolean validationEnabled) {
    this(new BundleLookup(), validationEnabled);
  }
  public BundleLookupBuilder(BundleLookupFluent<?> fluent) {
    this(fluent, false);
  }
  public BundleLookupBuilder(BundleLookupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BundleLookup(), validationEnabled);
  }
  public BundleLookupBuilder(BundleLookupFluent<?> fluent,BundleLookup instance) {
    this(fluent, instance, false);
  }
  public BundleLookupBuilder(BundleLookupFluent<?> fluent,BundleLookup instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCatalogSourceRef(instance.getCatalogSourceRef());
      fluent.withConditions(instance.getConditions());
      fluent.withIdentifier(instance.getIdentifier());
      fluent.withPath(instance.getPath());
      fluent.withProperties(instance.getProperties());
      fluent.withReplaces(instance.getReplaces());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BundleLookupBuilder(BundleLookup instance) {
    this(instance,false);
  }
  public BundleLookupBuilder(BundleLookup instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCatalogSourceRef(instance.getCatalogSourceRef());
      this.withConditions(instance.getConditions());
      this.withIdentifier(instance.getIdentifier());
      this.withPath(instance.getPath());
      this.withProperties(instance.getProperties());
      this.withReplaces(instance.getReplaces());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BundleLookupFluent<?> fluent;
  Boolean validationEnabled;
  public BundleLookup build() {
    BundleLookup buildable = new BundleLookup(fluent.getCatalogSourceRef(),fluent.getConditions(),fluent.getIdentifier(),fluent.getPath(),fluent.getProperties(),fluent.getReplaces());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}