package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AppLinkBuilder extends AppLinkFluentImpl<AppLinkBuilder> implements VisitableBuilder<AppLink,AppLinkBuilder>{
  public AppLinkBuilder() {
    this(false);
  }
  public AppLinkBuilder(Boolean validationEnabled) {
    this(new AppLink(), validationEnabled);
  }
  public AppLinkBuilder(AppLinkFluent<?> fluent) {
    this(fluent, false);
  }
  public AppLinkBuilder(AppLinkFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AppLink(), validationEnabled);
  }
  public AppLinkBuilder(AppLinkFluent<?> fluent,AppLink instance) {
    this(fluent, instance, false);
  }
  public AppLinkBuilder(AppLinkFluent<?> fluent,AppLink instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AppLinkBuilder(AppLink instance) {
    this(instance,false);
  }
  public AppLinkBuilder(AppLink instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AppLinkFluent<?> fluent;
  Boolean validationEnabled;
  public AppLink build() {
    AppLink buildable = new AppLink(fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}