package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MaintainerBuilder extends MaintainerFluentImpl<MaintainerBuilder> implements VisitableBuilder<Maintainer,MaintainerBuilder>{
  public MaintainerBuilder() {
    this(false);
  }
  public MaintainerBuilder(Boolean validationEnabled) {
    this(new Maintainer(), validationEnabled);
  }
  public MaintainerBuilder(MaintainerFluent<?> fluent) {
    this(fluent, false);
  }
  public MaintainerBuilder(MaintainerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Maintainer(), validationEnabled);
  }
  public MaintainerBuilder(MaintainerFluent<?> fluent,Maintainer instance) {
    this(fluent, instance, false);
  }
  public MaintainerBuilder(MaintainerFluent<?> fluent,Maintainer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEmail(instance.getEmail());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MaintainerBuilder(Maintainer instance) {
    this(instance,false);
  }
  public MaintainerBuilder(Maintainer instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEmail(instance.getEmail());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MaintainerFluent<?> fluent;
  Boolean validationEnabled;
  public Maintainer build() {
    Maintainer buildable = new Maintainer(fluent.getEmail(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}