package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OperatorGroupSpecBuilder extends OperatorGroupSpecFluent<OperatorGroupSpecBuilder> implements VisitableBuilder<OperatorGroupSpec,OperatorGroupSpecBuilder>{
  public OperatorGroupSpecBuilder() {
    this(new OperatorGroupSpec());
  }
  
  public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent) {
    this(fluent, new OperatorGroupSpec());
  }
  
  public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent,OperatorGroupSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OperatorGroupSpecBuilder(OperatorGroupSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OperatorGroupSpecFluent<?> fluent;
  
  public OperatorGroupSpec build() {
    OperatorGroupSpec buildable = new OperatorGroupSpec(fluent.buildSelector(),fluent.getServiceAccountName(),fluent.getStaticProvidedAPIs(),fluent.getTargetNamespaces(),fluent.getUpgradeStrategy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}