/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.Logo;
import io.fabric8.openshift.api.model.operator.v1.Theme;
import io.fabric8.openshift.api.model.operator.v1.ThemeBuilder;
import io.fabric8.openshift.api.model.operator.v1.ThemeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LogoFluent<A extends LogoFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ThemeBuilder> themes = new ArrayList();
    private String type;

    public LogoFluent() {
    }

    public LogoFluent(Logo instance) {
        this.copyInstance(instance);
    }

    public A addAllToThemes(Collection<Theme> items) {
        if (this.themes == null) {
            this.themes = new ArrayList();
        }
        for (Theme item : items) {
            ThemeBuilder builder = new ThemeBuilder(item);
            this._visitables.get((Object)"themes").add(builder);
            this.themes.add(builder);
        }
        return (A)((Object)this);
    }

    public ThemesNested<A> addNewTheme() {
        return new ThemesNested(-1, null);
    }

    public ThemesNested<A> addNewThemeLike(Theme item) {
        return new ThemesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToThemes(Theme ... items) {
        if (this.themes == null) {
            this.themes = new ArrayList();
        }
        for (Theme item : items) {
            ThemeBuilder builder = new ThemeBuilder(item);
            this._visitables.get((Object)"themes").add(builder);
            this.themes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToThemes(int index, Theme item) {
        if (this.themes == null) {
            this.themes = new ArrayList();
        }
        ThemeBuilder builder = new ThemeBuilder(item);
        if (index < 0 || index >= this.themes.size()) {
            this._visitables.get((Object)"themes").add(builder);
            this.themes.add(builder);
        } else {
            this._visitables.get((Object)"themes").add(builder);
            this.themes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Theme buildFirstTheme() {
        return this.themes.get(0).build();
    }

    public Theme buildLastTheme() {
        return this.themes.get(this.themes.size() - 1).build();
    }

    public Theme buildMatchingTheme(Predicate<ThemeBuilder> predicate) {
        for (ThemeBuilder item : this.themes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Theme buildTheme(int index) {
        return this.themes.get(index).build();
    }

    public List<Theme> buildThemes() {
        return this.themes != null ? LogoFluent.build(this.themes) : null;
    }

    protected void copyInstance(Logo instance) {
        Logo logo = instance = instance != null ? instance : new Logo();
        if (instance != null) {
            this.withThemes(instance.getThemes());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ThemesNested<A> editFirstTheme() {
        if (this.themes.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "themes"));
        }
        return this.setNewThemeLike(0, this.buildTheme(0));
    }

    public ThemesNested<A> editLastTheme() {
        int index = this.themes.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "themes"));
        }
        return this.setNewThemeLike(index, this.buildTheme(index));
    }

    public ThemesNested<A> editMatchingTheme(Predicate<ThemeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.themes.size(); ++i) {
            if (!predicate.test(this.themes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "themes"));
        }
        return this.setNewThemeLike(index, this.buildTheme(index));
    }

    public ThemesNested<A> editTheme(int index) {
        if (this.themes.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "themes"));
        }
        return this.setNewThemeLike(index, this.buildTheme(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogoFluent that = (LogoFluent)((Object)o);
        if (!Objects.equals(this.themes, that.themes)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingTheme(Predicate<ThemeBuilder> predicate) {
        for (ThemeBuilder item : this.themes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasThemes() {
        return this.themes != null && !this.themes.isEmpty();
    }

    public boolean hasType() {
        return this.type != null;
    }

    public int hashCode() {
        return Objects.hash(this.themes, this.type, this.additionalProperties);
    }

    public A removeAllFromThemes(Collection<Theme> items) {
        if (this.themes == null) {
            return (A)((Object)this);
        }
        for (Theme item : items) {
            ThemeBuilder builder = new ThemeBuilder(item);
            this._visitables.get((Object)"themes").remove((Object)builder);
            this.themes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromThemes(Theme ... items) {
        if (this.themes == null) {
            return (A)((Object)this);
        }
        for (Theme item : items) {
            ThemeBuilder builder = new ThemeBuilder(item);
            this._visitables.get((Object)"themes").remove((Object)builder);
            this.themes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromThemes(Predicate<ThemeBuilder> predicate) {
        if (this.themes == null) {
            return (A)((Object)this);
        }
        Iterator<ThemeBuilder> each = this.themes.iterator();
        List visitables = this._visitables.get((Object)"themes");
        while (each.hasNext()) {
            ThemeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ThemesNested<A> setNewThemeLike(int index, Theme item) {
        return new ThemesNested(index, item);
    }

    public A setToThemes(int index, Theme item) {
        if (this.themes == null) {
            this.themes = new ArrayList();
        }
        ThemeBuilder builder = new ThemeBuilder(item);
        if (index < 0 || index >= this.themes.size()) {
            this._visitables.get((Object)"themes").add(builder);
            this.themes.add(builder);
        } else {
            this._visitables.get((Object)"themes").add(builder);
            this.themes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.themes != null && !this.themes.isEmpty()) {
            sb.append("themes:");
            sb.append(this.themes);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withThemes(List<Theme> themes) {
        if (this.themes != null) {
            this._visitables.get((Object)"themes").clear();
        }
        if (themes != null) {
            this.themes = new ArrayList();
            for (Theme item : themes) {
                this.addToThemes(item);
            }
        } else {
            this.themes = null;
        }
        return (A)((Object)this);
    }

    public A withThemes(Theme ... themes) {
        if (this.themes != null) {
            this.themes.clear();
            this._visitables.remove((Object)"themes");
        }
        if (themes != null) {
            for (Theme item : themes) {
                this.addToThemes(item);
            }
        }
        return (A)((Object)this);
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public class ThemesNested<N>
    extends ThemeFluent<ThemesNested<N>>
    implements Nested<N> {
        ThemeBuilder builder;
        int index;

        ThemesNested(int index, Theme item) {
            this.index = index;
            this.builder = new ThemeBuilder(this, item);
        }

        public N and() {
            return (N)LogoFluent.this.setToThemes(this.index, this.builder.build());
        }

        public N endTheme() {
            return this.and();
        }
    }
}

