/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.MTUMigration;
import io.fabric8.openshift.api.model.operator.v1.MTUMigrationValues;
import io.fabric8.openshift.api.model.operator.v1.MTUMigrationValuesBuilder;
import io.fabric8.openshift.api.model.operator.v1.MTUMigrationValuesFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MTUMigrationFluent<A extends MTUMigrationFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private MTUMigrationValuesBuilder machine;
    private MTUMigrationValuesBuilder network;

    public MTUMigrationFluent() {
    }

    public MTUMigrationFluent(MTUMigration instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public MTUMigrationValues buildMachine() {
        return this.machine != null ? this.machine.build() : null;
    }

    public MTUMigrationValues buildNetwork() {
        return this.network != null ? this.network.build() : null;
    }

    protected void copyInstance(MTUMigration instance) {
        MTUMigration mTUMigration = instance = instance != null ? instance : new MTUMigration();
        if (instance != null) {
            this.withMachine(instance.getMachine());
            this.withNetwork(instance.getNetwork());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MachineNested<A> editMachine() {
        return this.withNewMachineLike(Optional.ofNullable(this.buildMachine()).orElse(null));
    }

    public NetworkNested<A> editNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(null));
    }

    public MachineNested<A> editOrNewMachine() {
        return this.withNewMachineLike(Optional.ofNullable(this.buildMachine()).orElse(new MTUMigrationValuesBuilder().build()));
    }

    public MachineNested<A> editOrNewMachineLike(MTUMigrationValues item) {
        return this.withNewMachineLike(Optional.ofNullable(this.buildMachine()).orElse(item));
    }

    public NetworkNested<A> editOrNewNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(new MTUMigrationValuesBuilder().build()));
    }

    public NetworkNested<A> editOrNewNetworkLike(MTUMigrationValues item) {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MTUMigrationFluent that = (MTUMigrationFluent)((Object)o);
        if (!Objects.equals((Object)this.machine, (Object)that.machine)) {
            return false;
        }
        if (!Objects.equals((Object)this.network, (Object)that.network)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMachine() {
        return this.machine != null;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.machine, this.network, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.machine != null) {
            sb.append("machine:");
            sb.append((Object)this.machine);
            sb.append(",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append((Object)this.network);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withMachine(MTUMigrationValues machine) {
        this._visitables.remove((Object)"machine");
        if (machine != null) {
            this.machine = new MTUMigrationValuesBuilder(machine);
            this._visitables.get((Object)"machine").add(this.machine);
        } else {
            this.machine = null;
            this._visitables.get((Object)"machine").remove((Object)this.machine);
        }
        return (A)((Object)this);
    }

    public A withNetwork(MTUMigrationValues network) {
        this._visitables.remove((Object)"network");
        if (network != null) {
            this.network = new MTUMigrationValuesBuilder(network);
            this._visitables.get((Object)"network").add(this.network);
        } else {
            this.network = null;
            this._visitables.get((Object)"network").remove((Object)this.network);
        }
        return (A)((Object)this);
    }

    public MachineNested<A> withNewMachine() {
        return new MachineNested(null);
    }

    public A withNewMachine(Long from, Long to) {
        return this.withMachine(new MTUMigrationValues(from, to));
    }

    public MachineNested<A> withNewMachineLike(MTUMigrationValues item) {
        return new MachineNested(item);
    }

    public NetworkNested<A> withNewNetwork() {
        return new NetworkNested(null);
    }

    public A withNewNetwork(Long from, Long to) {
        return this.withNetwork(new MTUMigrationValues(from, to));
    }

    public NetworkNested<A> withNewNetworkLike(MTUMigrationValues item) {
        return new NetworkNested(item);
    }

    public class NetworkNested<N>
    extends MTUMigrationValuesFluent<NetworkNested<N>>
    implements Nested<N> {
        MTUMigrationValuesBuilder builder;

        NetworkNested(MTUMigrationValues item) {
            this.builder = new MTUMigrationValuesBuilder(this, item);
        }

        public N and() {
            return (N)MTUMigrationFluent.this.withNetwork(this.builder.build());
        }

        public N endNetwork() {
            return this.and();
        }
    }

    public class MachineNested<N>
    extends MTUMigrationValuesFluent<MachineNested<N>>
    implements Nested<N> {
        MTUMigrationValuesBuilder builder;

        MachineNested(MTUMigrationValues item) {
            this.builder = new MTUMigrationValuesBuilder(this, item);
        }

        public N and() {
            return (N)MTUMigrationFluent.this.withMachine(this.builder.build());
        }

        public N endMachine() {
            return this.and();
        }
    }
}

