/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesBuilder;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddressesFluent;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfig;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSBuilder;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSFluent;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesBuilder;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StaticIPAMConfigFluent<A extends StaticIPAMConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<StaticIPAMAddressesBuilder> addresses = new ArrayList();
    private StaticIPAMDNSBuilder dns;
    private ArrayList<StaticIPAMRoutesBuilder> routes = new ArrayList();

    public StaticIPAMConfigFluent() {
    }

    public StaticIPAMConfigFluent(StaticIPAMConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<StaticIPAMAddresses> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (StaticIPAMAddresses item : items) {
            StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRoutes(Collection<StaticIPAMRoutes> items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (StaticIPAMRoutes item : items) {
            StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(builder);
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public A addNewAddress(String address, String gateway) {
        return this.addToAddresses(new StaticIPAMAddresses(address, gateway));
    }

    public AddressesNested<A> addNewAddressLike(StaticIPAMAddresses item) {
        return new AddressesNested(-1, item);
    }

    public RoutesNested<A> addNewRoute() {
        return new RoutesNested(-1, null);
    }

    public A addNewRoute(String destination, String gateway) {
        return this.addToRoutes(new StaticIPAMRoutes(destination, gateway));
    }

    public RoutesNested<A> addNewRouteLike(StaticIPAMRoutes item) {
        return new RoutesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(StaticIPAMAddresses ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (StaticIPAMAddresses item : items) {
            StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, StaticIPAMAddresses item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRoutes(StaticIPAMRoutes ... items) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        for (StaticIPAMRoutes item : items) {
            StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRoutes(int index, StaticIPAMRoutes item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
        if (index < 0 || index >= this.routes.size()) {
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(builder);
        } else {
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public StaticIPAMAddresses buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public List<StaticIPAMAddresses> buildAddresses() {
        return this.addresses != null ? StaticIPAMConfigFluent.build(this.addresses) : null;
    }

    public StaticIPAMDNS buildDns() {
        return this.dns != null ? this.dns.build() : null;
    }

    public StaticIPAMAddresses buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public StaticIPAMRoutes buildFirstRoute() {
        return this.routes.get(0).build();
    }

    public StaticIPAMAddresses buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public StaticIPAMRoutes buildLastRoute() {
        return this.routes.get(this.routes.size() - 1).build();
    }

    public StaticIPAMAddresses buildMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        for (StaticIPAMAddressesBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public StaticIPAMRoutes buildMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        for (StaticIPAMRoutesBuilder item : this.routes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public StaticIPAMRoutes buildRoute(int index) {
        return this.routes.get(index).build();
    }

    public List<StaticIPAMRoutes> buildRoutes() {
        return this.routes != null ? StaticIPAMConfigFluent.build(this.routes) : null;
    }

    protected void copyInstance(StaticIPAMConfig instance) {
        StaticIPAMConfig staticIPAMConfig = instance = instance != null ? instance : new StaticIPAMConfig();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withDns(instance.getDns());
            this.withRoutes(instance.getRoutes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public DnsNested<A> editDns() {
        return this.withNewDnsLike(Optional.ofNullable(this.buildDns()).orElse(null));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public RoutesNested<A> editFirstRoute() {
        if (this.routes.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "routes"));
        }
        return this.setNewRouteLike(0, this.buildRoute(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public RoutesNested<A> editLastRoute() {
        int index = this.routes.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "routes"));
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public RoutesNested<A> editMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.routes.size(); ++i) {
            if (!predicate.test(this.routes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "routes"));
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public DnsNested<A> editOrNewDns() {
        return this.withNewDnsLike(Optional.ofNullable(this.buildDns()).orElse(new StaticIPAMDNSBuilder().build()));
    }

    public DnsNested<A> editOrNewDnsLike(StaticIPAMDNS item) {
        return this.withNewDnsLike(Optional.ofNullable(this.buildDns()).orElse(item));
    }

    public RoutesNested<A> editRoute(int index) {
        if (this.routes.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "routes"));
        }
        return this.setNewRouteLike(index, this.buildRoute(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StaticIPAMConfigFluent that = (StaticIPAMConfigFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals((Object)this.dns, (Object)that.dns)) {
            return false;
        }
        if (!Objects.equals(this.routes, that.routes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasDns() {
        return this.dns != null;
    }

    public boolean hasMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        for (StaticIPAMAddressesBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        for (StaticIPAMRoutesBuilder item : this.routes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoutes() {
        return this.routes != null && !this.routes.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.dns, this.routes, this.additionalProperties});
    }

    public A removeAllFromAddresses(Collection<StaticIPAMAddresses> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (StaticIPAMAddresses item : items) {
            StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRoutes(Collection<StaticIPAMRoutes> items) {
        if (this.routes == null) {
            return (A)((Object)this);
        }
        for (StaticIPAMRoutes item : items) {
            StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
            this._visitables.get((Object)"routes").remove((Object)builder);
            this.routes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(StaticIPAMAddresses ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (StaticIPAMAddresses item : items) {
            StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRoutes(StaticIPAMRoutes ... items) {
        if (this.routes == null) {
            return (A)((Object)this);
        }
        for (StaticIPAMRoutes item : items) {
            StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
            this._visitables.get((Object)"routes").remove((Object)builder);
            this.routes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<StaticIPAMAddressesBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<StaticIPAMAddressesBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            StaticIPAMAddressesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRoutes(Predicate<StaticIPAMRoutesBuilder> predicate) {
        if (this.routes == null) {
            return (A)((Object)this);
        }
        Iterator<StaticIPAMRoutesBuilder> each = this.routes.iterator();
        List visitables = this._visitables.get((Object)"routes");
        while (each.hasNext()) {
            StaticIPAMRoutesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> setNewAddressLike(int index, StaticIPAMAddresses item) {
        return new AddressesNested(index, item);
    }

    public RoutesNested<A> setNewRouteLike(int index, StaticIPAMRoutes item) {
        return new RoutesNested(index, item);
    }

    public A setToAddresses(int index, StaticIPAMAddresses item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRoutes(int index, StaticIPAMRoutes item) {
        if (this.routes == null) {
            this.routes = new ArrayList();
        }
        StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
        if (index < 0 || index >= this.routes.size()) {
            this._visitables.get((Object)"routes").add(builder);
            this.routes.add(builder);
        } else {
            this._visitables.get((Object)"routes").add(builder);
            this.routes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.dns != null) {
            sb.append("dns:");
            sb.append((Object)this.dns);
            sb.append(",");
        }
        if (this.routes != null && !this.routes.isEmpty()) {
            sb.append("routes:");
            sb.append(this.routes);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddresses(List<StaticIPAMAddresses> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (StaticIPAMAddresses item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(StaticIPAMAddresses ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (StaticIPAMAddresses item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public A withDns(StaticIPAMDNS dns) {
        this._visitables.remove((Object)"dns");
        if (dns != null) {
            this.dns = new StaticIPAMDNSBuilder(dns);
            this._visitables.get((Object)"dns").add(this.dns);
        } else {
            this.dns = null;
            this._visitables.get((Object)"dns").remove((Object)this.dns);
        }
        return (A)((Object)this);
    }

    public DnsNested<A> withNewDns() {
        return new DnsNested(null);
    }

    public DnsNested<A> withNewDnsLike(StaticIPAMDNS item) {
        return new DnsNested(item);
    }

    public A withRoutes(List<StaticIPAMRoutes> routes) {
        if (this.routes != null) {
            this._visitables.get((Object)"routes").clear();
        }
        if (routes != null) {
            this.routes = new ArrayList();
            for (StaticIPAMRoutes item : routes) {
                this.addToRoutes(item);
            }
        } else {
            this.routes = null;
        }
        return (A)((Object)this);
    }

    public A withRoutes(StaticIPAMRoutes ... routes) {
        if (this.routes != null) {
            this.routes.clear();
            this._visitables.remove((Object)"routes");
        }
        if (routes != null) {
            for (StaticIPAMRoutes item : routes) {
                this.addToRoutes(item);
            }
        }
        return (A)((Object)this);
    }

    public class RoutesNested<N>
    extends StaticIPAMRoutesFluent<RoutesNested<N>>
    implements Nested<N> {
        StaticIPAMRoutesBuilder builder;
        int index;

        RoutesNested(int index, StaticIPAMRoutes item) {
            this.index = index;
            this.builder = new StaticIPAMRoutesBuilder(this, item);
        }

        public N and() {
            return (N)StaticIPAMConfigFluent.this.setToRoutes(this.index, this.builder.build());
        }

        public N endRoute() {
            return this.and();
        }
    }

    public class DnsNested<N>
    extends StaticIPAMDNSFluent<DnsNested<N>>
    implements Nested<N> {
        StaticIPAMDNSBuilder builder;

        DnsNested(StaticIPAMDNS item) {
            this.builder = new StaticIPAMDNSBuilder(this, item);
        }

        public N and() {
            return (N)StaticIPAMConfigFluent.this.withDns(this.builder.build());
        }

        public N endDns() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends StaticIPAMAddressesFluent<AddressesNested<N>>
    implements Nested<N> {
        StaticIPAMAddressesBuilder builder;
        int index;

        AddressesNested(int index, StaticIPAMAddresses item) {
            this.index = index;
            this.builder = new StaticIPAMAddressesBuilder(this, item);
        }

        public N and() {
            return (N)StaticIPAMConfigFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

