package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatuspageProviderBuilder extends StatuspageProviderFluentImpl<StatuspageProviderBuilder> implements VisitableBuilder<StatuspageProvider,StatuspageProviderBuilder>{
  public StatuspageProviderBuilder() {
    this(false);
  }
  public StatuspageProviderBuilder(Boolean validationEnabled) {
    this(new StatuspageProvider(), validationEnabled);
  }
  public StatuspageProviderBuilder(StatuspageProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public StatuspageProviderBuilder(StatuspageProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatuspageProvider(), validationEnabled);
  }
  public StatuspageProviderBuilder(StatuspageProviderFluent<?> fluent,StatuspageProvider instance) {
    this(fluent, instance, false);
  }
  public StatuspageProviderBuilder(StatuspageProviderFluent<?> fluent,StatuspageProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPageID(instance.getPageID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatuspageProviderBuilder(StatuspageProvider instance) {
    this(instance,false);
  }
  public StatuspageProviderBuilder(StatuspageProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPageID(instance.getPageID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StatuspageProviderFluent<?> fluent;
  Boolean validationEnabled;
  public StatuspageProvider build() {
    StatuspageProvider buildable = new StatuspageProvider(fluent.getPageID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}