package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StaticIPAMConfigFluentImpl<A extends StaticIPAMConfigFluent<A>> extends BaseFluent<A> implements StaticIPAMConfigFluent<A>{
  public StaticIPAMConfigFluentImpl() {
  }
  public StaticIPAMConfigFluentImpl(StaticIPAMConfig instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withDns(instance.getDns()); 
    this.withRoutes(instance.getRoutes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<StaticIPAMAddressesBuilder> addresses = new ArrayList<StaticIPAMAddressesBuilder>();
  private StaticIPAMDNSBuilder dns;
  private ArrayList<StaticIPAMRoutesBuilder> routes = new ArrayList<StaticIPAMRoutesBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToAddresses(Integer index,StaticIPAMAddresses item) {
    if (this.addresses == null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();}
    StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
  }
  public A setToAddresses(Integer index,StaticIPAMAddresses item) {
    if (this.addresses == null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();}
    StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
    if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
    if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
     return (A)this;
  }
  public A addToAddresses(io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();}
    for (StaticIPAMAddresses item : items) {StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(Collection<StaticIPAMAddresses> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();}
    for (StaticIPAMAddresses item : items) {StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses... items) {
    for (StaticIPAMAddresses item : items) {StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromAddresses(Collection<StaticIPAMAddresses> items) {
    for (StaticIPAMAddresses item : items) {StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAddresses(Predicate<StaticIPAMAddressesBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<StaticIPAMAddressesBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      StaticIPAMAddressesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAddresses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<StaticIPAMAddresses> getAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public List<StaticIPAMAddresses> buildAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public StaticIPAMAddresses buildAddress(Integer index) {
    return this.addresses.get(index).build();
  }
  public StaticIPAMAddresses buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public StaticIPAMAddresses buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public StaticIPAMAddresses buildMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
    for (StaticIPAMAddressesBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
    for (StaticIPAMAddressesBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(List<StaticIPAMAddresses> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
    if (addresses != null) {this.addresses = new ArrayList(); for (StaticIPAMAddresses item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.openshift.api.model.operator.v1.StaticIPAMAddresses... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (StaticIPAMAddresses item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addNewAddress(String address,String gateway) {
    return (A)addToAddresses(new StaticIPAMAddresses(address, gateway));
  }
  public StaticIPAMConfigFluent.AddressesNested<A> addNewAddress() {
    return new StaticIPAMConfigFluentImpl.AddressesNestedImpl();
  }
  public StaticIPAMConfigFluent.AddressesNested<A> addNewAddressLike(StaticIPAMAddresses item) {
    return new StaticIPAMConfigFluentImpl.AddressesNestedImpl(-1, item);
  }
  public StaticIPAMConfigFluent.AddressesNested<A> setNewAddressLike(Integer index,StaticIPAMAddresses item) {
    return new StaticIPAMConfigFluentImpl.AddressesNestedImpl(index, item);
  }
  public StaticIPAMConfigFluent.AddressesNested<A> editAddress(Integer index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public StaticIPAMConfigFluent.AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public StaticIPAMConfigFluent.AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public StaticIPAMConfigFluent.AddressesNested<A> editMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDns instead.
   * @return The buildable object.
   */
  @Deprecated
  public StaticIPAMDNS getDns() {
    return this.dns!=null ?this.dns.build():null;
  }
  public StaticIPAMDNS buildDns() {
    return this.dns!=null ?this.dns.build():null;
  }
  public A withDns(StaticIPAMDNS dns) {
    _visitables.get("dns").remove(this.dns);
    if (dns!=null){ this.dns= new StaticIPAMDNSBuilder(dns); _visitables.get("dns").add(this.dns);} else { this.dns = null; _visitables.get("dns").remove(this.dns); } return (A) this;
  }
  public Boolean hasDns() {
    return this.dns != null;
  }
  public StaticIPAMConfigFluent.DnsNested<A> withNewDns() {
    return new StaticIPAMConfigFluentImpl.DnsNestedImpl();
  }
  public StaticIPAMConfigFluent.DnsNested<A> withNewDnsLike(StaticIPAMDNS item) {
    return new StaticIPAMConfigFluentImpl.DnsNestedImpl(item);
  }
  public StaticIPAMConfigFluent.DnsNested<A> editDns() {
    return withNewDnsLike(getDns());
  }
  public StaticIPAMConfigFluent.DnsNested<A> editOrNewDns() {
    return withNewDnsLike(getDns() != null ? getDns(): new StaticIPAMDNSBuilder().build());
  }
  public StaticIPAMConfigFluent.DnsNested<A> editOrNewDnsLike(StaticIPAMDNS item) {
    return withNewDnsLike(getDns() != null ? getDns(): item);
  }
  public A addToRoutes(Integer index,StaticIPAMRoutes item) {
    if (this.routes == null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>();}
    StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(index >= 0 ? index : _visitables.get("routes").size(), builder);this.routes.add(index >= 0 ? index : routes.size(), builder); return (A)this;
  }
  public A setToRoutes(Integer index,StaticIPAMRoutes item) {
    if (this.routes == null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>();}
    StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
    if (index < 0 || index >= _visitables.get("routes").size()) { _visitables.get("routes").add(builder); } else { _visitables.get("routes").set(index, builder);}
    if (index < 0 || index >= routes.size()) { routes.add(builder); } else { routes.set(index, builder);}
     return (A)this;
  }
  public A addToRoutes(io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes... items) {
    if (this.routes == null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>();}
    for (StaticIPAMRoutes item : items) {StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  public A addAllToRoutes(Collection<StaticIPAMRoutes> items) {
    if (this.routes == null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>();}
    for (StaticIPAMRoutes item : items) {StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  public A removeFromRoutes(io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes... items) {
    for (StaticIPAMRoutes item : items) {StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoutes(Collection<StaticIPAMRoutes> items) {
    for (StaticIPAMRoutes item : items) {StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoutes(Predicate<StaticIPAMRoutesBuilder> predicate) {
    if (routes == null) return (A) this;
    final Iterator<StaticIPAMRoutesBuilder> each = routes.iterator();
    final List visitables = _visitables.get("routes");
    while (each.hasNext()) {
      StaticIPAMRoutesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRoutes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<StaticIPAMRoutes> getRoutes() {
    return routes != null ? build(routes) : null;
  }
  public List<StaticIPAMRoutes> buildRoutes() {
    return routes != null ? build(routes) : null;
  }
  public StaticIPAMRoutes buildRoute(Integer index) {
    return this.routes.get(index).build();
  }
  public StaticIPAMRoutes buildFirstRoute() {
    return this.routes.get(0).build();
  }
  public StaticIPAMRoutes buildLastRoute() {
    return this.routes.get(routes.size() - 1).build();
  }
  public StaticIPAMRoutes buildMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
    for (StaticIPAMRoutesBuilder item: routes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
    for (StaticIPAMRoutesBuilder item: routes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoutes(List<StaticIPAMRoutes> routes) {
    if (this.routes != null) { _visitables.get("routes").removeAll(this.routes);}
    if (routes != null) {this.routes = new ArrayList(); for (StaticIPAMRoutes item : routes){this.addToRoutes(item);}} else { this.routes = null;} return (A) this;
  }
  public A withRoutes(io.fabric8.openshift.api.model.operator.v1.StaticIPAMRoutes... routes) {
    if (this.routes != null) {this.routes.clear();}
    if (routes != null) {for (StaticIPAMRoutes item :routes){ this.addToRoutes(item);}} return (A) this;
  }
  public Boolean hasRoutes() {
    return routes != null && !routes.isEmpty();
  }
  public A addNewRoute(String destination,String gateway) {
    return (A)addToRoutes(new StaticIPAMRoutes(destination, gateway));
  }
  public StaticIPAMConfigFluent.RoutesNested<A> addNewRoute() {
    return new StaticIPAMConfigFluentImpl.RoutesNestedImpl();
  }
  public StaticIPAMConfigFluent.RoutesNested<A> addNewRouteLike(StaticIPAMRoutes item) {
    return new StaticIPAMConfigFluentImpl.RoutesNestedImpl(-1, item);
  }
  public StaticIPAMConfigFluent.RoutesNested<A> setNewRouteLike(Integer index,StaticIPAMRoutes item) {
    return new StaticIPAMConfigFluentImpl.RoutesNestedImpl(index, item);
  }
  public StaticIPAMConfigFluent.RoutesNested<A> editRoute(Integer index) {
    if (routes.size() <= index) throw new RuntimeException("Can't edit routes. Index exceeds size.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public StaticIPAMConfigFluent.RoutesNested<A> editFirstRoute() {
    if (routes.size() == 0) throw new RuntimeException("Can't edit first routes. The list is empty.");
    return setNewRouteLike(0, buildRoute(0));
  }
  public StaticIPAMConfigFluent.RoutesNested<A> editLastRoute() {
    int index = routes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last routes. The list is empty.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public StaticIPAMConfigFluent.RoutesNested<A> editMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<routes.size();i++) { 
    if (predicate.test(routes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching routes. No match found.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StaticIPAMConfigFluentImpl that = (StaticIPAMConfigFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (dns != null ? !dns.equals(that.dns) :that.dns != null) return false;
    if (routes != null ? !routes.equals(that.routes) :that.routes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  dns,  routes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (dns != null) { sb.append("dns:"); sb.append(dns + ","); }
    if (routes != null && !routes.isEmpty()) { sb.append("routes:"); sb.append(routes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AddressesNestedImpl<N> extends StaticIPAMAddressesFluentImpl<StaticIPAMConfigFluent.AddressesNested<N>> implements StaticIPAMConfigFluent.AddressesNested<N>,Nested<N>{
    AddressesNestedImpl(Integer index,StaticIPAMAddresses item) {
      this.index = index;
      this.builder = new StaticIPAMAddressesBuilder(this, item);
    }
    AddressesNestedImpl() {
      this.index = -1;
      this.builder = new StaticIPAMAddressesBuilder(this);
    }
    StaticIPAMAddressesBuilder builder;
    Integer index;
    public N and() {
      return (N) StaticIPAMConfigFluentImpl.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class DnsNestedImpl<N> extends StaticIPAMDNSFluentImpl<StaticIPAMConfigFluent.DnsNested<N>> implements StaticIPAMConfigFluent.DnsNested<N>,Nested<N>{
    DnsNestedImpl(StaticIPAMDNS item) {
      this.builder = new StaticIPAMDNSBuilder(this, item);
    }
    DnsNestedImpl() {
      this.builder = new StaticIPAMDNSBuilder(this);
    }
    StaticIPAMDNSBuilder builder;
    public N and() {
      return (N) StaticIPAMConfigFluentImpl.this.withDns(builder.build());
    }
    public N endDns() {
      return and();
    }
    
  }
  class RoutesNestedImpl<N> extends StaticIPAMRoutesFluentImpl<StaticIPAMConfigFluent.RoutesNested<N>> implements StaticIPAMConfigFluent.RoutesNested<N>,Nested<N>{
    RoutesNestedImpl(Integer index,StaticIPAMRoutes item) {
      this.index = index;
      this.builder = new StaticIPAMRoutesBuilder(this, item);
    }
    RoutesNestedImpl() {
      this.index = -1;
      this.builder = new StaticIPAMRoutesBuilder(this);
    }
    StaticIPAMRoutesBuilder builder;
    Integer index;
    public N and() {
      return (N) StaticIPAMConfigFluentImpl.this.setToRoutes(index,builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  
}