package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QuickStartsBuilder extends QuickStartsFluentImpl<QuickStartsBuilder> implements VisitableBuilder<QuickStarts,QuickStartsBuilder>{
  public QuickStartsBuilder() {
    this(false);
  }
  public QuickStartsBuilder(Boolean validationEnabled) {
    this(new QuickStarts(), validationEnabled);
  }
  public QuickStartsBuilder(QuickStartsFluent<?> fluent) {
    this(fluent, false);
  }
  public QuickStartsBuilder(QuickStartsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new QuickStarts(), validationEnabled);
  }
  public QuickStartsBuilder(QuickStartsFluent<?> fluent,QuickStarts instance) {
    this(fluent, instance, false);
  }
  public QuickStartsBuilder(QuickStartsFluent<?> fluent,QuickStarts instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisabled(instance.getDisabled()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public QuickStartsBuilder(QuickStarts instance) {
    this(instance,false);
  }
  public QuickStartsBuilder(QuickStarts instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisabled(instance.getDisabled()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  QuickStartsFluent<?> fluent;
  Boolean validationEnabled;
  public QuickStarts build() {
    QuickStarts buildable = new QuickStarts(fluent.getDisabled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}